/*
 * Decompiled with CFR 0.152.
 */
package com.wastedbankspace.ui.overlay;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.wastedbankspace.WastedBankSpacePlugin;
import com.wastedbankspace.model.StorableItem;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.runelite.api.Client;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;

public class StorageItemOverlay
extends WidgetItemOverlay {
    private static final ImageComponent ICON = new ImageComponent(ImageUtil.loadImageResource(WastedBankSpacePlugin.class, (String)"/overlaySmoller.png"));
    private final Point point;
    private final Client client;
    private final WastedBankSpacePlugin plugin;
    private final ItemManager itemManager;
    private final TooltipManager tooltipManager;
    private final Cache<Integer, BufferedImage> wastedSpaceImages = CacheBuilder.newBuilder().maximumSize(160L).expireAfterWrite(2L, TimeUnit.MINUTES).build();

    @Inject
    StorageItemOverlay(Client client, WastedBankSpacePlugin plugin, ItemManager itemManager, TooltipManager tooltipManager) {
        this.client = client;
        this.plugin = plugin;
        this.itemManager = itemManager;
        this.tooltipManager = tooltipManager;
        this.point = new Point();
        this.showOnBank();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        List<StorableItem> items = this.plugin.getEnabledItemLists();
        if (items.isEmpty() || itemWidget.getWidget().getParentId() != WidgetInfo.BANK_ITEM_CONTAINER.getId() || items.stream().noneMatch(i -> i.itemID == itemId)) {
            return;
        }
        StorableItem item = items.stream().filter(i -> i.itemID == itemId).findFirst().get();
        Rectangle bounds = itemWidget.getCanvasBounds();
        if (bounds.contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY())) {
            Tooltip t = new Tooltip(ColorUtil.prependColorTag((String)("Store @ " + item.location.getUiRepresentation()), (Color)new Color(238, 238, 238)));
            this.tooltipManager.add(t);
        }
        this.renderRibbon(graphics, ICON, bounds.x + bounds.width - 12, bounds.y + bounds.height - 12);
    }

    private void renderRibbon(Graphics2D graphics, ImageComponent ribbon, int x, int y) {
        this.point.setLocation(x, y);
        ribbon.setPreferredLocation(this.point);
        ribbon.render(graphics);
    }

    public Cache<Integer, BufferedImage> getWastedSpaceImages() {
        return this.wastedSpaceImages;
    }
}

