/*
 * Decompiled with CFR 0.152.
 */
package com.wastedbankspace.ui;

import com.wastedbankspace.WastedBankSpaceConfig;
import com.wastedbankspace.model.StorableItem;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WastedBankSpacePanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(WastedBankSpacePanel.class);
    private final JLabel numberOfItemsText;
    private final JList<String> data;
    private List<StorableItem> items;

    public WastedBankSpacePanel(Client client, TooltipManager tooltipManager, WastedBankSpaceConfig config, ItemManager itemManager) {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        this.numberOfItemsText = new JLabel("Please Visit Your Bank");
        this.data = new JList<String>(){

            @Override
            public String getToolTipText(MouseEvent me) {
                int index = this.locationToIndex(me.getPoint());
                if (index > -1 && WastedBankSpacePanel.this.items != null) {
                    return WastedBankSpacePanel.this.items.get((int)index).location.getUiRepresentation();
                }
                return null;
            }
        };
        this.data.setSelectionMode(0);
        this.data.setSelectedIndex(0);
        this.data.setVisibleRowCount(10);
        String tipTab = "    ";
        String[] tips = new String[]{"Tips", "1: Talk to the Wise Old Man", "    to remove Junk Quest Items", "2: Murky Matt combines ", "    jewelery charges", "3: Make item sets at the ge", "3.1: PHat and Mask can be combined", "4: Clue items in PoH (future update)", "5: Costumes, sets, and capes in PoH", "6: Store bolts in a bolt pouch"};
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add(this.numberOfItemsText, c);
        ++c.gridy;
        this.add(this.data, c);
        ++c.gridy;
        for (String tipString : tips) {
            this.add(new JLabel(tipString), c);
            ++c.gridy;
        }
    }

    public void setWastedBankSpaceItems(List<StorableItem> items) {
        this.items = items;
        this.numberOfItemsText.setText("Number of Items Wasting Space: " + items.size());
        this.data.setListData(new Vector<String>(StorableItem.storableListToString(items)));
        this.updateUI();
    }
}

