/*
 * Decompiled with CFR 0.152.
 */
package com.wastedbankspace;

import com.google.inject.Provides;
import com.wastedbankspace.WastedBankSpaceConfig;
import com.wastedbankspace.model.StorableItem;
import com.wastedbankspace.model.StorageLocation;
import com.wastedbankspace.model.StorageLocationEnabler;
import com.wastedbankspace.ui.WastedBankSpacePanel;
import com.wastedbankspace.ui.overlay.StorageItemOverlay;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Wasted Bank Space")
public class WastedBankSpacePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WastedBankSpacePlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ItemManager itemManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private StorageItemOverlay storageItemOverlay;
    @Inject
    private TooltipManager tooltipManager;
    @Inject
    private WastedBankSpaceConfig config;
    private static final BufferedImage ICON = ImageUtil.loadImageResource(WastedBankSpacePlugin.class, (String)"/overlaySmoll.png");
    public static final String CONFIG_GROUP = "Wasted Bank Space";
    private static boolean prepared = false;
    private final List<StorageLocationEnabler> storageLocationEnablers = Arrays.asList(new StorageLocationEnabler(StorageLocation.TACKLE_BOX, () -> this.config.tackleBoxCheck(), StorableItem.tackleBoxItems), new StorageLocationEnabler(StorageLocation.STEEL_KEY_RING, () -> this.config.keyRingCheck(), StorableItem.steelKeyRingItems), new StorageLocationEnabler(StorageLocation.TOOL_LEP, () -> this.config.toolLepCheck(), StorableItem.toolLepItems), new StorageLocationEnabler(StorageLocation.MASTER_SCROLL_BOOK, () -> this.config.masterScrollBookCheck(), StorableItem.masterScrollBookItems), new StorageLocationEnabler(StorageLocation.FOSSIL_STORAGE, () -> this.config.fossilStorageCheck(), StorableItem.fossilStorageItems), new StorageLocationEnabler(StorageLocation.PURO_PURO, () -> this.config.elnockInquisitorCheck(), StorableItem.puroPuroItems), new StorageLocationEnabler(StorageLocation.FLAMTAER_BAG, () -> this.config.flamtaerBagCheck(), StorableItem.flamtaerBagItems), new StorageLocationEnabler(StorageLocation.NIGHTMARE_ZONE, () -> this.config.nightmareZoneCheck(), StorableItem.nightmareZoneItems), new StorageLocationEnabler(StorageLocation.SEEDS, () -> this.config.seedCheck(), StorableItem.seedItems), new StorageLocationEnabler(StorageLocation.OAK_TREASURE_CHEST, () -> this.config.treasureChestStorageCheck(), StorableItem.oakTreasureChestItems), new StorageLocationEnabler(StorageLocation.TEAK_TREASURE_CHEST, () -> this.config.treasureChestStorageCheck(), StorableItem.teakTreasureChestItems), new StorageLocationEnabler(StorageLocation.MAHOGANY_TREASURE_CHEST, () -> this.config.treasureChestStorageCheck(), StorableItem.mahoganyTreasureChestItems), new StorageLocationEnabler(StorageLocation.FANCY_DRESS_BOX, () -> this.config.fancyDressBoxStorageCheck(), StorableItem.fancyDressBoxItems), new StorageLocationEnabler(StorageLocation.MAGIC_WARDROBE, () -> this.config.magicWardrobeStorageCheck(), StorableItem.magicWardrobeItems), new StorageLocationEnabler(StorageLocation.TOY_BOX, () -> this.config.toyBoxCheck(), StorableItem.toyBoxItems), new StorageLocationEnabler(StorageLocation.SPICE_RACK, () -> this.config.spiceRackStorageCheck(), StorableItem.spiceRackItems));
    private NavigationButton navButton;
    private WastedBankSpacePanel panel;
    private Map<Integer, Integer> inventoryMap = new HashMap<Integer, Integer>();

    @Provides
    WastedBankSpaceConfig provideConfig(ConfigManager configManager) {
        return (WastedBankSpaceConfig)configManager.getConfig(WastedBankSpaceConfig.class);
    }

    protected void startUp() throws Exception {
        this.panel = new WastedBankSpacePanel(this.client, this.tooltipManager, this.config, this.itemManager);
        this.navButton = NavigationButton.builder().tooltip(CONFIG_GROUP).priority(8).icon(ICON).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.overlayManager.add((Overlay)this.storageItemOverlay);
        if (!prepared) {
            this.clientThread.invoke(() -> {
                switch (this.client.getGameState()) {
                    case LOGIN_SCREEN: 
                    case LOGIN_SCREEN_AUTHENTICATOR: 
                    case LOGGING_IN: 
                    case LOADING: 
                    case LOGGED_IN: 
                    case CONNECTION_LOST: 
                    case HOPPING: {
                        StorableItem.prepareStorableItemNames(this.itemManager);
                        prepared = true;
                        return true;
                    }
                }
                return false;
            });
        }
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        this.overlayManager.remove((Overlay)this.storageItemOverlay);
        this.navButton = null;
        this.panel = null;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged ev) {
        if (ev.getContainerId() == InventoryID.BANK.getId()) {
            this.updateItemsFromBankContainer(ev.getItemContainer());
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals(CONFIG_GROUP)) {
            return;
        }
        this.updateWastedBankSpace();
    }

    private void updateItemsFromBankContainer(ItemContainer c) {
        if (c == null) {
            return;
        }
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        for (Item item : c.getItems()) {
            int itemID;
            ItemComposition itemComposition;
            if (item.getId() == -1 || (itemComposition = this.itemManager.getItemComposition(itemID = item.getId())).getPlaceholderTemplateId() != -1) continue;
            if (itemComposition.getNote() != -1) {
                itemID = itemComposition.getLinkedNoteId();
            }
            int qty = m.getOrDefault(itemID, 0) + item.getQuantity();
            m.put(itemID, qty);
        }
        this.inventoryMap = m;
        this.updateWastedBankSpace();
    }

    private void updateWastedBankSpace() {
        ArrayList<StorableItem> storableItemsInBank = new ArrayList<StorableItem>();
        for (StorableItem item : this.getEnabledItemLists()) {
            int id = item.itemID;
            if (!this.inventoryMap.containsKey(id)) continue;
            storableItemsInBank.add(item);
        }
        SwingUtilities.invokeLater(() -> this.panel.setWastedBankSpaceItems(storableItemsInBank));
    }

    public List<StorableItem> getEnabledItemLists() {
        ArrayList<StorableItem> ret = new ArrayList<StorableItem>();
        for (StorageLocationEnabler sle : this.storageLocationEnablers) {
            ret.addAll(sle.GetStorableItems());
        }
        return ret;
    }
}

