/*
 * Decompiled with CFR 0.152.
 */
package com.foodie;

import com.foodie.FoodieConfig;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.inject.Provides;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Foodie", description="Custom sayings to accompany a delicious treat.")
public class FoodiePlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private FoodieConfig config;
    private Map<String, String> foodToPhrases = new HashMap<String, String>();
    private String lastFoodEaten = "";

    protected void startUp() throws Exception {
        this.updateFoodToPhrasesMap();
    }

    protected void shutDown() throws Exception {
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if ((chatMessage.getType().equals((Object)ChatMessageType.SPAM) || chatMessage.getType().equals((Object)ChatMessageType.GAMEMESSAGE)) && (this.isDrink(chatMessage) || this.isFood(chatMessage))) {
            ArrayList<String> phrases = new ArrayList<String>();
            for (String food : this.foodToPhrases.keySet()) {
                if (!chatMessage.getMessage().contains(food)) continue;
                phrases.add(this.foodToPhrases.get(food));
            }
            if (this.config.randomize()) {
                if (this.isDrink(chatMessage)) {
                    phrases.addAll(Arrays.asList(this.config.drinkPhrases().split(":")));
                } else if (this.isFood(chatMessage)) {
                    phrases.addAll(Arrays.asList(this.config.foodPhrases().split(":")));
                }
            }
            if (this.lastFoodEaten.equals(chatMessage.getMessage()) && this.config.pickyEater()) {
                phrases.clear();
                phrases.addAll(Arrays.asList(this.config.pickyEaterPhrases().split(":")));
            }
            if (phrases.isEmpty()) {
                return;
            }
            this.lastFoodEaten = chatMessage.getMessage();
            this.client.getLocalPlayer().setOverheadText((String)phrases.get(new Random().nextInt(phrases.size())));
            this.client.getLocalPlayer().setOverheadCycle(120);
            return;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!"foodie".equals(event.getGroup())) {
            return;
        }
        this.updateFoodToPhrasesMap();
    }

    @Provides
    FoodieConfig provideConfig(ConfigManager configManager) {
        return (FoodieConfig)configManager.getConfig(FoodieConfig.class);
    }

    private void updateFoodToPhrasesMap() {
        this.foodToPhrases.clear();
        this.foodToPhrases = this.initFoodToPhrases();
        if (this.config.foodToPhrases() != null && !this.config.foodToPhrases().isEmpty()) {
            Type mapType = new TypeToken<Map<String, String>>(){}.getType();
            this.foodToPhrases.putAll((Map)new Gson().fromJson(this.config.foodToPhrases(), mapType));
        }
    }

    private Map<String, String> initFoodToPhrases() {
        HashMap<String, String> foodToPhrases = new HashMap<String, String>();
        foodToPhrases.put("manta ray", "This one's for my boy Steve Irwin!");
        foodToPhrases.put("Wizard's Mind Bomb", "Wimbly bimbly, my brain now thinks nimbly!");
        foodToPhrases.put("lobster", "Bleh! Prisoner food!");
        foodToPhrases.put("purple sweet", "Ooo, piece of candy!");
        foodToPhrases.put("meat", "Bleh! It's raw!");
        return foodToPhrases;
    }

    private boolean isDrink(ChatMessage message) {
        return message.getMessage().startsWith("You drink");
    }

    private boolean isFood(ChatMessage message) {
        return message.getMessage().startsWith("You eat");
    }
}

