/*
 * Decompiled with CFR 0.152.
 */
package com.parchmentalert;

import com.parchmentalert.ParchmentAlertConfig;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.client.game.ItemManager;

@Singleton
public class ParchmentAlertService {
    private final Client client;
    private final ParchmentAlertConfig config;
    private final ItemManager itemManager;
    private final int[] UnparchmentedItems = new int[]{12954, 19722, 6570, 21295, 10499, 27374, 21793, 21791, 21795, 13329, 21284, 21898, 27363, 21780, 21784, 21776, 8844, 8845, 8846, 8847, 8848, 8849, 8850, 23230, 12954, 19722, 22322, 8842, 8841, 8839, 8840, 26467, 26463, 26465, 11665, 26477, 11664, 26475, 11663, 26473, 12639, 12637, 12638, 24195, 24198, 24201, 24204, 10548, 10551, 28067, 10547, 10550, 10549, 10555, 4069, 4070, 4504, 4505, 4510, 4509, 4070, 11893, 11894, 11896, 11895, 11898, 11897, 11899, 11900, 11901, 13073, 26471, 13072, 26469, 27624, 25489, 25490, 25492, 25491};

    @Inject
    private ParchmentAlertService(Client client, ParchmentAlertConfig config, ItemManager itemManager) {
        this.config = config;
        this.client = client;
        this.itemManager = itemManager;
    }

    public ArrayList<Integer> getItems() {
        ArrayList<Integer> missingParchment = new ArrayList<Integer>();
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        for (int i = 0; i < this.UnparchmentedItems.length; ++i) {
            if ((equipment == null || !equipment.contains(this.UnparchmentedItems[i])) && (inventory == null || !inventory.contains(this.UnparchmentedItems[i]))) continue;
            missingParchment.add(this.UnparchmentedItems[i]);
        }
        if (this.config.extraItems() == null || this.config.extraItems().equals("")) {
            return missingParchment;
        }
        String[] idStrs = this.config.extraItems().split(",");
        ArrayList<Integer> extraItems = new ArrayList<Integer>();
        for (String s : idStrs) {
            try {
                Integer i = Integer.parseInt(s);
                extraItems.add(i);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (int i = 0; i < extraItems.size(); ++i) {
            if ((equipment == null || !equipment.contains(((Integer)extraItems.get(i)).intValue())) && (inventory == null || !inventory.contains(((Integer)extraItems.get(i)).intValue()))) continue;
            missingParchment.add((Integer)extraItems.get(i));
        }
        return missingParchment;
    }
}

