/*
 * Decompiled with CFR 0.152.
 */
package com.parchmentalert;

import com.google.inject.Provides;
import com.parchmentalert.ParchmentAlertConfig;
import com.parchmentalert.ParchmentAlertOverlay;
import com.parchmentalert.ParchmentAlertService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Trouver Parchment Alert")
public class ParchmentAlertPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ParchmentAlertPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ParchmentAlertConfig config;
    @Inject
    private ParchmentAlertService service;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ParchmentAlertOverlay overlay;
    private boolean isRunning;
    @Inject
    ClientThread thread;
    private HashSet<String> unparchedNames;

    protected void startUp() throws Exception {
        this.isRunning = true;
        this.thread.invokeLater(() -> this.update());
    }

    protected void shutDown() throws Exception {
        this.isRunning = false;
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        this.update();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (this.unparchedNames != null) {
            this.unparchedNames.clear();
        }
        this.thread.invokeLater(() -> this.update());
    }

    private void update() {
        Widget wi;
        int wildyLevel = 0;
        if (this.config.willNotify() == ParchmentAlertConfig.HighlightSetting.DEEP_WILD && (wi = this.client.getWidget(WidgetInfo.PVP_WILDERNESS_LEVEL)) != null) {
            if (wi.isHidden()) {
                wildyLevel = -1;
            } else {
                String wildyText = wi.getText();
                if (wildyText != null && !wildyText.equals("") && wildyText.matches(".*\\d.*")) {
                    Matcher m = Pattern.compile("(\\d+)").matcher(wildyText);
                    m.find();
                    wildyLevel = Integer.valueOf(m.group());
                }
            }
        }
        if (this.config.willNotify() == ParchmentAlertConfig.HighlightSetting.ENABLED || this.config.willNotify() == ParchmentAlertConfig.HighlightSetting.DEEP_WILD && wildyLevel >= this.config.wildernessLevel() || this.config.willNotify() == ParchmentAlertConfig.HighlightSetting.PVP && (this.client.getVarbitValue(5963) == 1 || this.client.getVarbitValue(8121) == 1)) {
            ArrayList<Integer> unparchedItems = this.service.getItems();
            HashSet<String> unparchedNames = new HashSet<String>();
            unparchedNames.clear();
            if (unparchedItems.size() == 0) {
                this.overlayManager.remove((Overlay)this.overlay);
                return;
            }
            for (Integer i : unparchedItems) {
                ItemComposition ip = this.client.getItemDefinition(i.intValue());
                unparchedNames.add(ip.getName());
            }
            if (this.config.showNames()) {
                this.unparchedNames = unparchedNames;
            }
            this.overlayManager.add((Overlay)this.overlay);
        } else {
            this.overlayManager.remove((Overlay)this.overlay);
        }
    }

    public HashSet<String> getUnparchedNames() {
        return this.unparchedNames;
    }

    public boolean getIsRunning() {
        return this.isRunning && this.config.willNotify() != ParchmentAlertConfig.HighlightSetting.DISABLED;
    }

    @Provides
    ParchmentAlertConfig provideConfig(ConfigManager configManager) {
        return (ParchmentAlertConfig)configManager.getConfig(ParchmentAlertConfig.class);
    }
}

