/*
 * Decompiled with CFR 0.152.
 */
package com.parchmentalert;

import com.parchmentalert.ParchmentAlertConfig;
import com.parchmentalert.ParchmentAlertPlugin;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;

@Singleton
public class ParchmentAlertOverlay
extends OverlayPanel {
    private final ParchmentAlertConfig config;
    private final Client client;
    private final String lockMsg = "You need to lock items!";
    private final ParchmentAlertPlugin plugin;

    @Inject
    private ParchmentAlertOverlay(ParchmentAlertConfig config, Client client, ParchmentAlertPlugin plugin) {
        this.config = config;
        this.client = client;
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.getIsRunning()) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        FontMetrics metrics = graphics.getFontMetrics();
        HashSet<String> unparchedNames = this.plugin.getUnparchedNames();
        String itemList = "";
        int longest = 0;
        if (unparchedNames != null && unparchedNames.size() > 0) {
            for (String s : unparchedNames) {
                int t = metrics.stringWidth(s);
                if (t <= longest) continue;
                longest = t;
            }
        }
        int w = Math.max(129, metrics.stringWidth("You need to lock items!") + longest + 14);
        this.panelComponent.setPreferredSize(new Dimension(w, 0));
        this.panelComponent.getChildren().add(LineComponent.builder().left("You need to lock items!").right(itemList).build());
        if (unparchedNames != null && unparchedNames.size() > 0) {
            for (String s : unparchedNames) {
                this.panelComponent.getChildren().add(LineComponent.builder().right(s).build());
            }
        }
        if (this.config.flash()) {
            if (this.client.getGameCycle() % this.config.interval() >= this.config.interval() / 2) {
                this.panelComponent.setBackgroundColor(this.config.bg());
            } else {
                this.panelComponent.setBackgroundColor(this.config.flashColor());
            }
        } else {
            this.panelComponent.setBackgroundColor(this.config.bg());
        }
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        return this.panelComponent.render(graphics);
    }
}

