/*
 * Decompiled with CFR 0.152.
 */
package no.kriops.drystreak;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import no.kriops.drystreak.DryStreakConfig;
import no.kriops.drystreak.DryStreakPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Dry Streak")
public class DryStreakPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DryStreakPlugin.class);
    @Inject
    @Nullable
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private DryStreakConfig config;
    private NavigationButton navButton;
    private DryStreakPanel dryStreakPanel;

    @Provides
    DryStreakConfig provideConfig(ConfigManager configManager) {
        return (DryStreakConfig)configManager.getConfig(DryStreakConfig.class);
    }

    protected void startUp() {
        BufferedImage icon;
        this.dryStreakPanel = (DryStreakPanel)((Object)this.injector.getInstance(DryStreakPanel.class));
        try {
            icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/icon.png");
        }
        catch (Exception e) {
            icon = new BufferedImage(40, 40, 1);
        }
        this.navButton = NavigationButton.builder().tooltip("Dry Streak").priority(5).panel((PluginPanel)this.dryStreakPanel).icon(icon).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        super.shutDown();
    }
}

