/*
 * Decompiled with CFR 0.152.
 */
package no.kriops.drystreak;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.ColorJButton;
import net.runelite.client.ui.components.FlatTextField;
import net.runelite.client.ui.components.shadowlabel.JShadowedLabel;
import no.kriops.drystreak.DryStreakCalculation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DryStreakPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(DryStreakPanel.class);
    private final DryStreakCalculation dryStreakCalculation;
    private final FlatTextField dropRate;

    @Inject
    public DryStreakPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 10, 0);
        JShadowedLabel dropRateLabel = new JShadowedLabel("<html>Enter drop rate:</html>");
        this.add((Component)dropRateLabel, c);
        ++c.gridy;
        this.dropRate = new FlatTextField();
        this.dropRate.setPreferredSize(new Dimension(205, 30));
        this.dropRate.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.dropRate.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.dropRate.setMinimumSize(new Dimension(0, 30));
        this.add((Component)this.dropRate, c);
        ++c.gridy;
        ColorJButton button = new ColorJButton("Calculate", new Color(255, 255, 255));
        this.add((Component)button, c);
        ++c.gridy;
        JShadowedLabel resultLabel = new JShadowedLabel("<html>Enter drop rate as 1/25, 25 or 0.04.</html>");
        this.add((Component)resultLabel, c);
        ++c.gridy;
        this.dryStreakCalculation = new DryStreakCalculation(this.dropRate, resultLabel);
        this.dropRate.addActionListener((ActionListener)this.dryStreakCalculation);
        button.addActionListener((ActionListener)this.dryStreakCalculation);
    }

    public void onActivate() {
        super.onActivate();
        this.dropRate.requestFocusInWindow();
    }

    public void onDeactivate() {
        super.onDeactivate();
    }
}

