/*
 * Decompiled with CFR 0.152.
 */
package no.kriops.drystreak;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Optional;
import net.runelite.client.ui.components.FlatTextField;
import net.runelite.client.ui.components.shadowlabel.JShadowedLabel;
import org.apache.commons.lang3.math.Fraction;

public class DryStreakCalculation
implements ActionListener {
    final FlatTextField inputField;
    final JShadowedLabel outputField;

    DryStreakCalculation(FlatTextField inputField, JShadowedLabel outputField) {
        this.inputField = inputField;
        this.outputField = outputField;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String explanation = "At this number of kills, you are less likely to have received zero drops than not.";
        String message = Optional.ofNullable(this.inputField.getText()).map(input -> {
            try {
                return 1.0 / (double)Integer.parseInt(input);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.parseDouble(input);
                }
                catch (NumberFormatException numberFormatException2) {
                    try {
                        return Fraction.getFraction((String)input).doubleValue();
                    }
                    catch (NumberFormatException numberFormatException3) {
                        return null;
                    }
                }
            }
        }).map(p -> {
            if (0.0 < p && p < 1.0) {
                try {
                    int result = DryStreakCalculation.geometricMedian(p);
                    return String.format("<p>Expected dry streak: %s</p><br><p>%s</p>", result, "At this number of kills, you are less likely to have received zero drops than not.");
                }
                catch (Exception ignored) {
                    return "Error performing calculation.";
                }
            }
            return "Drop rate must be greater than zero and less than one.";
        }).orElse("Unable to parse input.");
        this.outputField.setText(DryStreakCalculation.asHtml(message));
    }

    private static String asHtml(String input) {
        return String.format("<html>%s</html>", input);
    }

    private static int geometricMedian(double p) {
        return Math.max(0, (int)Math.ceil(-1.0 / DryStreakCalculation.log2(1.0 - p)) - 1);
    }

    private static double log2(double x) {
        return Math.log(x) / Math.log(2.0);
    }
}

