/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg;

import com.ericversteeg.InventoryTotalConfig;
import com.ericversteeg.InventoryTotalLedgerItem;
import com.ericversteeg.InventoryTotalMode;
import com.ericversteeg.InventoryTotalOverlay;
import com.ericversteeg.InventoryTotalRunData;
import com.ericversteeg.InventoryTotalState;
import com.google.gson.Gson;
import com.google.inject.Provides;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.RuneScapeProfileChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.HotkeyListener;

@PluginDescriptor(name="Inventory Total", description="Totals item prices in your inventory.")
public class InventoryTotalPlugin
extends Plugin {
    static final int COINS = 995;
    static final int TOTAL_GP_INDEX = 0;
    static final int TOTAL_QTY_INDEX = 1;
    static final int NO_PROFIT_LOSS_TIME = -1;
    static final int RUNEPOUCH_ITEM_ID = 12791;
    static final int DIVINE_RUNEPOUCH_ITEM_ID = 27281;
    @Inject
    private InventoryTotalOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    @Inject
    private InventoryTotalConfig config;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;
    @Inject
    private KeyManager keyManager;
    private String profileKey = "";
    private InventoryTotalRunData runData;
    private InventoryTotalMode mode = InventoryTotalMode.TOTAL;
    private InventoryTotalState state = InventoryTotalState.NONE;
    private InventoryTotalState prevState = InventoryTotalState.NONE;
    private long totalGp = 0L;
    private long totalQty = 0L;
    private long initialGp = 0L;
    private long runStartTime = 0L;
    private long lastWriteSaveTime = 0L;
    private InventoryTotalMode plToggleOverride = null;
    private KeyListener plToggleKeyListener;
    private static final int[] RUNEPOUCH_AMOUNT_VARBITS = new int[]{1624, 1625, 1626, 14286};
    private static final int[] RUNEPOUCH_RUNE_VARBITS = new int[]{29, 1622, 1623, 14285};

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.runData = new InventoryTotalRunData();
        this.registerPLToggleKey();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.unregisterPLToggleKey();
    }

    @Subscribe
    public void onRuneScapeProfileChanged(RuneScapeProfileChanged e) {
        this.profileKey = this.configManager.getRSProfileKey();
        if (this.profileKey != null) {
            this.runData = this.getSavedData();
        }
    }

    @Provides
    InventoryTotalConfig provideConfig(ConfigManager configManager) {
        return (InventoryTotalConfig)configManager.getConfig(InventoryTotalConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged config) {
        if (config.getGroup().equals("inventorytotal")) {
            if (config.getKey().equals("enableProfitLoss")) {
                this.plToggleOverride = null;
            } else if (config.getKey().equals("profitLossToggleKey")) {
                this.unregisterPLToggleKey();
                this.registerPLToggleKey();
            }
        }
    }

    private void registerPLToggleKey() {
        this.plToggleKeyListener = new HotkeyListener(() -> this.config.profitLossToggleKey()){

            public void hotkeyPressed() {
                InventoryTotalPlugin.this.plToggleOverride = InventoryTotalPlugin.this.mode == InventoryTotalMode.TOTAL ? InventoryTotalMode.PROFIT_LOSS : InventoryTotalMode.TOTAL;
            }
        };
        this.keyManager.registerKeyListener(this.plToggleKeyListener);
    }

    private void unregisterPLToggleKey() {
        if (this.plToggleKeyListener != null) {
            this.keyManager.unregisterKeyListener(this.plToggleKeyListener);
        }
    }

    void onNewRun() {
        this.overlay.showInterstitial();
        this.runStartTime = Instant.now().toEpochMilli();
        this.runData.ignoredItems = this.getIgnoredItems();
    }

    void postNewRun() {
        this.runData.initialItemQtys.clear();
        int inventoryTotal = this.getInventoryTotals(true)[0];
        int equipmentTotal = this.getEquipmentTotal(true);
        this.runData.profitLossInitialGp = inventoryTotal + equipmentTotal;
        this.initialGp = this.mode == InventoryTotalMode.PROFIT_LOSS ? this.runData.profitLossInitialGp : 0L;
        this.writeSavedData();
        this.overlay.hideInterstitial();
    }

    void onBank() {
        this.runData.profitLossInitialGp = 0L;
        this.runData.itemPrices.clear();
        this.initialGp = 0L;
        this.runStartTime = 0L;
        this.writeSavedData();
    }

    int[] getInventoryTotals(boolean isNewRun) {
        ItemContainer itemContainer = this.overlay.getInventoryItemContainer();
        if (itemContainer == null) {
            return new int[2];
        }
        Item[] items = itemContainer.getItems();
        LinkedList<Item> allItems = new LinkedList<Item>(Arrays.asList(items));
        if (allItems.stream().anyMatch(s -> s.getId() == 12791 || s.getId() == 27281)) {
            allItems.addAll(this.getRunepouchContents());
        }
        int totalQty = 0;
        int totalGp = 0;
        for (Item item : allItems) {
            int itemId = item.getId();
            ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
            String itemName = itemComposition.getName();
            boolean ignore = this.runData.ignoredItems.stream().anyMatch(s -> {
                String lcItemName = itemName.toLowerCase();
                String lcS = s.toLowerCase();
                return lcItemName.contains(lcS);
            });
            if (ignore) continue;
            boolean isNoted = itemComposition.getNote() != -1;
            int realItemId = isNoted ? itemComposition.getLinkedNoteId() : itemId;
            int gePrice = this.runData.itemPrices.containsKey(realItemId) ? this.runData.itemPrices.get(realItemId).intValue() : this.itemManager.getItemPrice(realItemId);
            int itemQty = item.getQuantity();
            int totalPrice = realItemId == 995 ? itemQty : itemQty * gePrice;
            totalGp += totalPrice;
            totalQty += itemQty;
            if (realItemId != 995 && !this.runData.itemPrices.containsKey(realItemId)) {
                this.runData.itemPrices.put(realItemId, gePrice);
            }
            if (isNewRun) {
                if (this.runData.initialItemQtys.containsKey(realItemId)) {
                    this.runData.initialItemQtys.put(realItemId, this.runData.initialItemQtys.get(realItemId) + itemQty);
                } else {
                    this.runData.initialItemQtys.put(realItemId, itemQty);
                }
            }
            if (this.runData.itemQtys.containsKey(realItemId)) {
                this.runData.itemQtys.put(realItemId, this.runData.itemQtys.get(realItemId) + itemQty);
                continue;
            }
            this.runData.itemQtys.put(realItemId, itemQty);
        }
        int[] totals = new int[]{totalGp, totalQty};
        return totals;
    }

    int getEquipmentTotal(boolean isNewRun) {
        ItemContainer itemContainer = this.overlay.getEquipmentItemContainer();
        if (itemContainer == null) {
            return 0;
        }
        Item ring = itemContainer.getItem(EquipmentInventorySlot.RING.getSlotIdx());
        Item ammo = itemContainer.getItem(EquipmentInventorySlot.AMMO.getSlotIdx());
        Player player = this.client.getLocalPlayer();
        int[] ids = player.getPlayerComposition().getEquipmentIds();
        LinkedList<Integer> eIds = new LinkedList<Integer>();
        for (int id : ids) {
            if (id < 512) continue;
            eIds.add(id - 512);
        }
        if (ring != null) {
            eIds.add(ring.getId());
        }
        if (ammo != null) {
            eIds.add(ammo.getId());
        }
        int eTotal = 0;
        Iterator iterator = eIds.iterator();
        while (iterator.hasNext()) {
            int itemId = (Integer)iterator.next();
            int qty = 1;
            if (ammo != null && itemId == ammo.getId()) {
                qty = ammo.getQuantity();
            }
            int gePrice = this.runData.itemPrices.containsKey(itemId) ? this.runData.itemPrices.get(itemId).intValue() : this.itemManager.getItemPrice(itemId);
            int totalPrice = qty * gePrice;
            eTotal += totalPrice;
            if (!this.runData.itemPrices.containsKey(itemId)) {
                this.runData.itemPrices.put(itemId, gePrice);
            }
            if (isNewRun) {
                if (this.runData.initialItemQtys.containsKey(itemId)) {
                    this.runData.initialItemQtys.put(itemId, this.runData.initialItemQtys.get(itemId) + qty);
                } else {
                    this.runData.initialItemQtys.put(itemId, qty);
                }
            }
            if (this.runData.itemQtys.containsKey(itemId)) {
                this.runData.itemQtys.put(itemId, this.runData.itemQtys.get(itemId) + qty);
                continue;
            }
            this.runData.itemQtys.put(itemId, qty);
        }
        return eTotal;
    }

    List<InventoryTotalLedgerItem> getInventoryLedger() {
        LinkedList<InventoryTotalLedgerItem> ledgerItems = new LinkedList<InventoryTotalLedgerItem>();
        ItemContainer itemContainer = this.overlay.getInventoryItemContainer();
        if (itemContainer == null) {
            return new LinkedList<InventoryTotalLedgerItem>();
        }
        Item[] items = itemContainer.getItems();
        LinkedList<Item> allItems = new LinkedList<Item>(Arrays.asList(items));
        if (allItems.stream().anyMatch(s -> s.getId() == 12791 || s.getId() == 27281)) {
            allItems.addAll(this.getRunepouchContents());
        }
        HashMap<Integer, Integer> qtyMap = new HashMap<Integer, Integer>();
        for (Item item : allItems) {
            int itemId = item.getId();
            ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
            String itemName = itemComposition.getName();
            boolean ignore = this.runData.ignoredItems.stream().anyMatch(s -> {
                String lcItemName = itemName.toLowerCase();
                String lcS = s.toLowerCase();
                return lcItemName.contains(lcS);
            });
            if (ignore) continue;
            boolean isNoted = itemComposition.getNote() != -1;
            int realItemId = isNoted ? itemComposition.getLinkedNoteId() : itemId;
            int itemQty = item.getQuantity();
            if (qtyMap.containsKey(realItemId)) {
                qtyMap.put(realItemId, (Integer)qtyMap.get(realItemId) + itemQty);
                continue;
            }
            qtyMap.put(realItemId, itemQty);
        }
        for (Integer itemId : qtyMap.keySet()) {
            ItemComposition itemComposition = this.itemManager.getItemComposition(itemId.intValue());
            String itemName = itemComposition.getName();
            Integer qty = (Integer)qtyMap.get(itemId);
            Integer total = this.runData.itemPrices.get(itemId);
            if (itemId == 995 || total == null) {
                total = 1;
            }
            ledgerItems.add(new InventoryTotalLedgerItem(itemName, qty, total));
        }
        return ledgerItems;
    }

    List<InventoryTotalLedgerItem> getProfitLossLedger() {
        Map<Integer, Integer> prices = this.runData.itemPrices;
        Map<Integer, Integer> initialQtys = this.runData.initialItemQtys;
        Map<Integer, Integer> qtys = this.runData.itemQtys;
        HashMap<Integer, Integer> qtyDifferences = new HashMap<Integer, Integer>();
        HashSet<Integer> combinedQtyKeys = new HashSet<Integer>();
        combinedQtyKeys.addAll(qtys.keySet());
        combinedQtyKeys.addAll(initialQtys.keySet());
        for (Integer itemId : combinedQtyKeys) {
            Integer initialQty = initialQtys.get(itemId);
            Integer qty = qtys.get(itemId);
            if (initialQty == null) {
                initialQty = 0;
            }
            if (qty == null) {
                qty = 0;
            }
            qtyDifferences.put(itemId, qty - initialQty);
        }
        LinkedList<InventoryTotalLedgerItem> ledgerItems = new LinkedList<InventoryTotalLedgerItem>();
        for (Integer itemId : qtyDifferences.keySet()) {
            ItemComposition itemComposition = this.itemManager.getItemComposition(itemId.intValue());
            Integer price = prices.get(itemId);
            if (price == null) {
                price = 1;
            }
            Integer qtyDifference = (Integer)qtyDifferences.get(itemId);
            List filteredList = ledgerItems.stream().filter(item -> item.getDescription().equals(itemComposition.getName())).collect(Collectors.toList());
            if (!filteredList.isEmpty()) {
                ((InventoryTotalLedgerItem)filteredList.get(0)).addQuantityDifference(qtyDifference);
                continue;
            }
            if (price <= 0) continue;
            ledgerItems.add(new InventoryTotalLedgerItem(itemComposition.getName(), qtyDifference, price));
        }
        return ledgerItems;
    }

    private List<Item> getRunepouchContents() {
        EnumComposition runepouchEnum = this.client.getEnum(982);
        ArrayList<Item> items = new ArrayList<Item>(RUNEPOUCH_AMOUNT_VARBITS.length);
        for (int i = 0; i < RUNEPOUCH_AMOUNT_VARBITS.length; ++i) {
            int runeId;
            int amount = this.client.getVarbitValue(RUNEPOUCH_AMOUNT_VARBITS[i]);
            if (amount <= 0 || (runeId = this.client.getVarbitValue(RUNEPOUCH_RUNE_VARBITS[i])) == 0) continue;
            int itemId = runepouchEnum.getIntValue(runeId);
            Item item = new Item(itemId, amount);
            items.add(item);
        }
        return items;
    }

    void writeSavedData() {
        if (this.state == InventoryTotalState.BANK || Instant.now().toEpochMilli() - this.lastWriteSaveTime < 600L) {
            return;
        }
        String profile = this.configManager.getRSProfileKey();
        String json = this.gson.toJson((Object)this.runData);
        this.configManager.setConfiguration("inventorytotal", profile, "inventory_total_data", json);
        this.lastWriteSaveTime = Instant.now().toEpochMilli();
    }

    private InventoryTotalRunData getSavedData() {
        String profile = this.configManager.getRSProfileKey();
        String json = this.configManager.getConfiguration("inventorytotal", profile, "inventory_total_data");
        InventoryTotalRunData savedData = (InventoryTotalRunData)this.gson.fromJson(json, InventoryTotalRunData.class);
        if (savedData == null) {
            return new InventoryTotalRunData();
        }
        return savedData;
    }

    private LinkedList<String> getIgnoredItems() {
        return new LinkedList<String>(Arrays.asList(this.config.ignoredItems().split("\\s*,\\s*")));
    }

    long elapsedRunTime() {
        if (this.runStartTime == 0L || !this.config.showRunTime()) {
            return -1L;
        }
        return Instant.now().minusMillis(this.runStartTime).toEpochMilli();
    }

    void setMode(InventoryTotalMode mode) {
        this.mode = mode;
        switch (mode) {
            case TOTAL: {
                this.initialGp = 0L;
                break;
            }
            case PROFIT_LOSS: {
                this.initialGp = this.runData.profitLossInitialGp;
            }
        }
    }

    public InventoryTotalMode getMode() {
        return this.mode;
    }

    void setState(InventoryTotalState state) {
        this.prevState = this.state;
        this.state = state;
    }

    public InventoryTotalState getState() {
        return this.state;
    }

    public InventoryTotalState getPreviousState() {
        return this.prevState;
    }

    public long getProfitGp() {
        return this.totalGp - this.initialGp;
    }

    void setTotalGp(long totalGp) {
        this.totalGp = totalGp;
    }

    public long getTotalGp() {
        return this.totalGp;
    }

    void setTotalQty(long totalQty) {
        this.totalQty = totalQty;
    }

    public long getTotalQty() {
        return this.totalQty;
    }

    public InventoryTotalRunData getRunData() {
        return this.runData;
    }

    public InventoryTotalMode getPLToggleOverride() {
        return this.plToggleOverride;
    }
}

