/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg;

import com.ericversteeg.InventoryTotalConfig;
import com.ericversteeg.InventoryTotalLedgerItem;
import com.ericversteeg.InventoryTotalMode;
import com.ericversteeg.InventoryTotalPlugin;
import com.ericversteeg.InventoryTotalState;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.TextComponent;
import net.runelite.client.util.ImageUtil;

class InventoryTotalOverlay
extends Overlay {
    private static final int TEXT_Y_OFFSET = 17;
    private static final String PROFIT_LOSS_TIME_FORMAT = "%02d:%02d:%02d";
    private static final String PROFIT_LOSS_TIME_NO_HOURS_FORMAT = "%02d:%02d";
    private static final int HORIZONTAL_PADDING = 10;
    private static final int BANK_CLOSE_DELAY = 1200;
    private static final Color LEDGER_BACKGROUND_COLOR = new Color(27, 27, 27, 202);
    static final int COINS = 995;
    private final Client client;
    private final InventoryTotalPlugin plugin;
    private final InventoryTotalConfig config;
    private final ItemManager itemManager;
    private Widget inventoryWidget;
    private ItemContainer inventoryItemContainer;
    private ItemContainer equipmentItemContainer;
    private boolean onceBank = false;
    private boolean showInterstitial = false;
    private boolean postNewRun = false;
    private long newRunTime = 0L;
    private int invX = -1;
    private int invY = -1;
    private int invW = -1;
    private int invH = -1;

    @Inject
    private InventoryTotalOverlay(Client client, InventoryTotalPlugin plugin, InventoryTotalConfig config, ItemManager itemManager) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.itemManager = itemManager;
    }

    void updatePluginState() {
        this.inventoryWidget = this.client.getWidget(0x950000);
        this.inventoryItemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        this.equipmentItemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (this.plugin.getPLToggleOverride() == null) {
            if (this.config.enableProfitLoss()) {
                this.plugin.setMode(InventoryTotalMode.PROFIT_LOSS);
            } else {
                this.plugin.setMode(InventoryTotalMode.TOTAL);
            }
        } else if (this.plugin.getPLToggleOverride() == InventoryTotalMode.PROFIT_LOSS) {
            this.plugin.setMode(InventoryTotalMode.PROFIT_LOSS);
        } else if (this.plugin.getPLToggleOverride() == InventoryTotalMode.TOTAL) {
            this.plugin.setMode(InventoryTotalMode.TOTAL);
        }
        boolean isBank = false;
        if (this.inventoryWidget == null || this.inventoryWidget.getCanvasLocation().getX() < 0 || this.inventoryWidget.isHidden()) {
            Widget[] altInventoryWidgets;
            Widget[] widgetArray = altInventoryWidgets = new Widget[]{this.client.getWidget(983043), this.client.getWidget(0xC00002)};
            int n = widgetArray.length;
            for (int i = 0; i < n; ++i) {
                Widget altInventoryWidget;
                this.inventoryWidget = altInventoryWidget = widgetArray[i];
                if (this.inventoryWidget == null || this.inventoryWidget.isHidden()) continue;
                isBank = true;
                if (this.onceBank) break;
                this.onceBank = true;
                break;
            }
        }
        if (isBank) {
            this.plugin.setState(InventoryTotalState.BANK);
        } else {
            this.plugin.setState(InventoryTotalState.RUN);
        }
        boolean newRun = this.plugin.getPreviousState() == InventoryTotalState.BANK && this.plugin.getState() == InventoryTotalState.RUN;
        this.plugin.getRunData().itemQtys.clear();
        int[] inventoryTotals = this.plugin.getInventoryTotals(false);
        int inventoryTotal = inventoryTotals[0];
        int equipmentTotal = this.plugin.getEquipmentTotal(false);
        int inventoryQty = inventoryTotals[1];
        int totalGp = inventoryTotal;
        if (this.plugin.getState() == InventoryTotalState.RUN && this.plugin.getMode() == InventoryTotalMode.PROFIT_LOSS) {
            totalGp += equipmentTotal;
        }
        this.plugin.setTotalGp(totalGp);
        this.plugin.setTotalQty(inventoryQty);
        if (newRun) {
            this.plugin.onNewRun();
            this.postNewRun = true;
            this.newRunTime = Instant.now().toEpochMilli();
        } else if (this.plugin.getPreviousState() == InventoryTotalState.RUN && this.plugin.getState() == InventoryTotalState.BANK) {
            this.plugin.onBank();
        }
        if (this.postNewRun && Instant.now().toEpochMilli() - this.newRunTime > 1200L) {
            this.plugin.postNewRun();
            this.postNewRun = false;
        }
    }

    public Dimension render(Graphics2D graphics) {
        this.updatePluginState();
        if (this.inventoryWidget != null) {
            this.invX = this.inventoryWidget.getCanvasLocation().getX();
            this.invY = this.inventoryWidget.getCanvasLocation().getY();
            this.invW = this.inventoryWidget.getWidth();
            this.invH = this.inventoryWidget.getHeight();
        }
        if (this.invX < 0 || this.invY < 0 || this.invW < 0 || this.invH < 0) {
            return null;
        }
        if (this.config.hideWithInventory() && (this.inventoryWidget == null || this.inventoryWidget.isHidden())) {
            return null;
        }
        int height = 20;
        String totalText = this.getTotalText(this.plugin.getProfitGp());
        String formattedRunTime = this.getFormattedRunTime();
        String runTimeText = null;
        if (formattedRunTime != null) {
            runTimeText = " (" + formattedRunTime + ")";
        }
        long total = this.plugin.getProfitGp();
        if (this.showInterstitial) {
            total = 0L;
            totalText = this.plugin.getMode() == InventoryTotalMode.PROFIT_LOSS ? "0" : this.getTotalText(this.plugin.getTotalGp());
        }
        this.renderTotal(this.config, graphics, this.plugin, this.plugin.getTotalQty(), total, totalText, runTimeText, height);
        return null;
    }

    private void renderTotal(InventoryTotalConfig config, Graphics2D graphics, InventoryTotalPlugin plugin, long totalQty, long total, String totalText, String runTimeText, int height) {
        int mouseY;
        Point mouse;
        int mouseX;
        RoundRectangle2D.Double roundRectangle2D;
        int containerAlpha;
        Color textColor;
        Color borderColor;
        Color backgroundColor;
        int numCoins;
        int imageSize = 15;
        boolean showCoinStack = config.showCoinStack();
        if (total > Integer.MAX_VALUE) {
            numCoins = Integer.MAX_VALUE;
        } else if (total < Integer.MIN_VALUE) {
            numCoins = Integer.MIN_VALUE;
        } else {
            numCoins = (int)total;
            if (numCoins == 0) {
                numCoins = 1000000;
            }
        }
        numCoins = Math.abs(numCoins);
        if (totalQty == 0L && !config.showOnEmpty() || plugin.getState() == InventoryTotalState.BANK && !config.showWhileBanking()) {
            return;
        }
        graphics.setFont(FontManager.getRunescapeSmallFont());
        int totalWidth = graphics.getFontMetrics().stringWidth(totalText);
        int fixedRunTimeWidth = 0;
        int actualRunTimeWidth = 0;
        int imageWidthWithPadding = 0;
        if (runTimeText != null && runTimeText.length() >= 2) {
            fixedRunTimeWidth = 5 * (runTimeText.length() - 2) + 6 + 5;
            actualRunTimeWidth = graphics.getFontMetrics().stringWidth(runTimeText);
        }
        if (showCoinStack) {
            imageWidthWithPadding = imageSize + 3;
        }
        int width = totalWidth + fixedRunTimeWidth + imageWidthWithPadding + 20;
        int x = this.invX + this.invW / 2 - width / 2;
        switch (config.horizontalAlignment()) {
            case CENTER: {
                break;
            }
            case LEFT: {
                x = this.invX;
                break;
            }
            case RIGHT: {
                x = this.invX + this.invW - width;
            }
        }
        int xOffset = config.inventoryXOffset();
        if (config.isInventoryXOffsetNegative()) {
            xOffset *= -1;
        }
        x += xOffset;
        int yOffset = config.inventoryYOffset();
        if (config.isInventoryYOffsetNegative()) {
            yOffset *= -1;
        }
        int y = this.invY - height - yOffset;
        if (plugin.getState() == InventoryTotalState.BANK || plugin.getMode() == InventoryTotalMode.TOTAL) {
            backgroundColor = config.totalColor();
            borderColor = config.borderColor();
            textColor = config.textColor();
        } else if (total >= 0L) {
            backgroundColor = config.profitColor();
            borderColor = config.profitBorderColor();
            textColor = config.profitTextColor();
        } else {
            backgroundColor = config.lossColor();
            borderColor = config.lossBorderColor();
            textColor = config.lossTextColor();
        }
        int cornerRadius = config.cornerRadius();
        if (!config.roundCorners()) {
            cornerRadius = 0;
        }
        if ((containerAlpha = backgroundColor.getAlpha()) > 0) {
            graphics.setColor(borderColor);
            graphics.drawRoundRect(x, y, width + 1, height + 1, cornerRadius, cornerRadius);
        }
        graphics.setColor(backgroundColor);
        graphics.fillRoundRect(x + 1, y + 1, width, height, cornerRadius, cornerRadius);
        TextComponent textComponent = new TextComponent();
        textComponent.setColor(textColor);
        textComponent.setText(totalText);
        textComponent.setPosition(new java.awt.Point(x + 10, y + 17));
        textComponent.render(graphics);
        if (runTimeText != null) {
            textComponent = new TextComponent();
            textComponent.setColor(textColor);
            textComponent.setText(runTimeText);
            textComponent.setPosition(new java.awt.Point(x + width - 10 - actualRunTimeWidth - imageWidthWithPadding, y + 17));
            textComponent.render(graphics);
        }
        if (showCoinStack) {
            int imageOffset = 4;
            Object coinsImage = this.itemManager.getImage(995, numCoins, false);
            coinsImage = ImageUtil.resizeImage((BufferedImage)coinsImage, (int)imageSize, (int)imageSize);
            graphics.drawImage((Image)coinsImage, x + width - 10 - imageSize + imageOffset, y + 3, null);
        }
        if ((roundRectangle2D = new RoundRectangle2D.Double(x, y, width + 1, height + 1, cornerRadius, cornerRadius)).contains(mouseX = (mouse = this.client.getMouseCanvasPosition()).getX(), mouseY = mouse.getY()) && plugin.getState() != InventoryTotalState.BANK && Instant.now().toEpochMilli() - this.newRunTime > 1700L && config.showTooltip()) {
            if (plugin.getMode() == InventoryTotalMode.PROFIT_LOSS) {
                this.renderProfitLossLedger(graphics);
            } else {
                this.renderLedger(graphics);
            }
        }
    }

    private void renderLedger(Graphics2D graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        List ledger = this.plugin.getInventoryLedger().stream().filter(item -> item.getQty() != 0).collect(Collectors.toList());
        if (ledger.isEmpty()) {
            return;
        }
        ledger = ledger.stream().sorted(Comparator.comparingInt(o -> -(o.getQty() * o.getAmount()))).collect(Collectors.toList());
        int total = ledger.stream().mapToInt(item -> item.getQty() * item.getAmount()).sum();
        ledger.add(new InventoryTotalLedgerItem("Total", 1, total));
        String[] descriptions = (String[])ledger.stream().map(item -> {
            Object desc = item.getDescription();
            if (item.getQty() != 0 && Math.abs(item.getQty()) != 1 && !item.getDescription().contains("Total") && !item.getDescription().contains("Coins")) {
                desc = NumberFormat.getInstance(Locale.ENGLISH).format(Math.abs(item.getQty())) + " " + (String)desc;
            }
            return desc;
        }).toArray(String[]::new);
        Integer[] prices = (Integer[])ledger.stream().map(item -> item.getQty() * item.getAmount()).toArray(Integer[]::new);
        String[] formattedPrices = (String[])Arrays.stream(prices).map(p -> NumberFormat.getInstance(Locale.ENGLISH).format(p)).toArray(String[]::new);
        Object[] rowWidths = (Integer[])IntStream.range(0, descriptions.length).mapToObj(i -> fontMetrics.stringWidth(descriptions[i]) + fontMetrics.stringWidth(formattedPrices[i])).toArray(Integer[]::new);
        Arrays.sort(rowWidths);
        Point mouse = this.client.getMouseCanvasPosition();
        int mouseX = mouse.getX();
        int mouseY = mouse.getY();
        int sectionPadding = 5;
        int rowW = (Integer)rowWidths[rowWidths.length - 1] + 20 + 10 + 2;
        int rowH = fontMetrics.getHeight();
        int h = descriptions.length * rowH + 8 + sectionPadding + 1;
        int x = mouseX - rowW - 10;
        int y = mouseY - h / 2;
        int cornerRadius = 0;
        graphics.setColor(LEDGER_BACKGROUND_COLOR);
        graphics.fillRoundRect(x, y, rowW, h, cornerRadius, cornerRadius);
        int borderWidth = 1;
        graphics.setColor(Color.decode("#0b0b0b"));
        graphics.setStroke(new BasicStroke(borderWidth));
        graphics.drawRoundRect(x - borderWidth / 2, y - borderWidth / 2, rowW + borderWidth / 2, h + borderWidth / 2, cornerRadius, cornerRadius);
        if (descriptions.length == prices.length) {
            int yOffset = 0;
            String prevDesc = "";
            for (int i2 = 0; i2 < descriptions.length; ++i2) {
                String desc = descriptions[i2];
                if (!prevDesc.contains("Total") && desc.contains("Total")) {
                    yOffset += sectionPadding;
                } else if (i2 > 0 && prices[i2 - 1] >= 0 && prices[i2] < 0 && !prevDesc.contains("Total")) {
                    yOffset += sectionPadding;
                }
                int textX = x + 5 + 2;
                int textY = y + rowH * i2 + 17 + yOffset;
                TextComponent textComponent = new TextComponent();
                if (desc.contains("Total") && desc.length() == 5) {
                    textComponent.setColor(Color.ORANGE);
                } else if (desc.contains("Total")) {
                    textComponent.setColor(Color.YELLOW);
                } else {
                    textComponent.setColor(Color.decode("#FFF7E3"));
                }
                textComponent.setText(desc);
                textComponent.setPosition(new java.awt.Point(textX, textY));
                textComponent.render(graphics);
                prevDesc = desc;
                int price = prices[i2];
                String formattedPrice = NumberFormat.getInstance(Locale.ENGLISH).format(price);
                int textW = fontMetrics.stringWidth(formattedPrice);
                textX = x + rowW - 5 - textW;
                textY = y + rowH * i2 + 17 + yOffset;
                textComponent = new TextComponent();
                if (price > 0) {
                    textComponent.setColor(Color.GREEN);
                } else {
                    textComponent.setColor(Color.WHITE);
                }
                textComponent.setText(formattedPrice);
                textComponent.setPosition(new java.awt.Point(textX, textY));
                textComponent.render(graphics);
            }
        }
    }

    private void renderProfitLossLedger(Graphics2D graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        List ledger = this.plugin.getProfitLossLedger().stream().filter(item -> item.getQty() != 0).collect(Collectors.toList());
        List gain = ledger.stream().filter(item -> item.getQty() > 0).collect(Collectors.toList());
        List loss = ledger.stream().filter(item -> item.getQty() < 0).collect(Collectors.toList());
        gain = gain.stream().sorted(Comparator.comparingInt(o -> -(o.getQty() * o.getAmount()))).collect(Collectors.toList());
        loss = loss.stream().sorted(Comparator.comparingInt(o -> o.getQty() * o.getAmount())).collect(Collectors.toList());
        ledger = new LinkedList();
        ledger.addAll(gain);
        ledger.addAll(loss);
        if (ledger.isEmpty()) {
            return;
        }
        int totalGain = gain.stream().mapToInt(item -> item.getQty() * item.getAmount()).sum();
        int totalLoss = loss.stream().mapToInt(item -> item.getQty() * item.getAmount()).sum();
        int total = ledger.stream().mapToInt(item -> item.getQty() * item.getAmount()).sum();
        ledger.add(new InventoryTotalLedgerItem("Total Gain", 1, totalGain));
        ledger.add(new InventoryTotalLedgerItem("Total Loss", 1, totalLoss));
        ledger.add(new InventoryTotalLedgerItem("Total", 1, total));
        String[] descriptions = (String[])ledger.stream().map(item -> {
            Object desc = item.getDescription();
            if (item.getQty() != 0 && Math.abs(item.getQty()) != 1 && !item.getDescription().contains("Total") && !item.getDescription().contains("Coins")) {
                desc = NumberFormat.getInstance(Locale.ENGLISH).format(Math.abs(item.getQty())) + " " + (String)desc;
            }
            return desc;
        }).toArray(String[]::new);
        Integer[] prices = (Integer[])ledger.stream().map(item -> item.getQty() * item.getAmount()).toArray(Integer[]::new);
        String[] formattedPrices = (String[])Arrays.stream(prices).map(p -> NumberFormat.getInstance(Locale.ENGLISH).format(p)).toArray(String[]::new);
        Object[] rowWidths = (Integer[])IntStream.range(0, descriptions.length).mapToObj(i -> fontMetrics.stringWidth(descriptions[i]) + fontMetrics.stringWidth(formattedPrices[i])).toArray(Integer[]::new);
        Arrays.sort(rowWidths);
        Point mouse = this.client.getMouseCanvasPosition();
        int mouseX = mouse.getX();
        int mouseY = mouse.getY();
        int sectionPadding = 5;
        int rowW = (Integer)rowWidths[rowWidths.length - 1] + 20 + 10 + 2;
        int rowH = fontMetrics.getHeight();
        int sectionPaddingTotal = sectionPadding;
        if (!gain.isEmpty() && !loss.isEmpty()) {
            sectionPaddingTotal += sectionPadding;
        }
        int h = descriptions.length * rowH + 8 + sectionPaddingTotal + 1;
        int x = mouseX - rowW - 10;
        int y = mouseY - h / 2;
        int cornerRadius = 0;
        graphics.setColor(LEDGER_BACKGROUND_COLOR);
        graphics.fillRoundRect(x, y, rowW, h, cornerRadius, cornerRadius);
        int borderWidth = 1;
        graphics.setColor(Color.decode("#0b0b0b"));
        graphics.setStroke(new BasicStroke(borderWidth));
        graphics.drawRoundRect(x - borderWidth / 2, y - borderWidth / 2, rowW + borderWidth / 2, h + borderWidth / 2, cornerRadius, cornerRadius);
        if (descriptions.length == prices.length) {
            int yOffset = 0;
            String prevDesc = "";
            for (int i2 = 0; i2 < descriptions.length; ++i2) {
                String desc = descriptions[i2];
                if (!prevDesc.contains("Total") && desc.contains("Total")) {
                    yOffset += sectionPadding;
                } else if (i2 > 0 && prices[i2 - 1] >= 0 && prices[i2] < 0 && !prevDesc.contains("Total")) {
                    yOffset += sectionPadding;
                }
                int textX = x + 5 + 2;
                int textY = y + rowH * i2 + 17 + yOffset;
                TextComponent textComponent = new TextComponent();
                if (desc.contains("Total") && desc.length() == 5) {
                    textComponent.setColor(Color.ORANGE);
                } else if (desc.contains("Total")) {
                    textComponent.setColor(Color.YELLOW);
                } else {
                    textComponent.setColor(Color.decode("#FFF7E3"));
                }
                textComponent.setText(desc);
                textComponent.setPosition(new java.awt.Point(textX, textY));
                textComponent.render(graphics);
                prevDesc = desc;
                int price = prices[i2];
                String formattedPrice = NumberFormat.getInstance(Locale.ENGLISH).format(price);
                int textW = fontMetrics.stringWidth(formattedPrice);
                textX = x + rowW - 5 - textW;
                textY = y + rowH * i2 + 17 + yOffset;
                textComponent = new TextComponent();
                if (price > 0) {
                    textComponent.setColor(Color.GREEN);
                } else if (price < 0) {
                    textComponent.setColor(Color.RED);
                }
                textComponent.setText(formattedPrice);
                textComponent.setPosition(new java.awt.Point(textX, textY));
                textComponent.render(graphics);
            }
        }
    }

    private String getTotalText(long total) {
        if (this.config.showExactGp()) {
            return this.getExactFormattedGp(total);
        }
        String totalText = this.getFormattedGp(total);
        return totalText.replace(".0", "");
    }

    private String getFormattedGp(long total) {
        if (total >= 1000000000L || total <= -1000000000L) {
            double bTotal = (double)total / 1.0E9;
            return this.getTruncatedTotal(bTotal) + "B";
        }
        if (total >= 1000000L || total <= -1000000L) {
            double mTotal = (double)total / 1000000.0;
            return this.getTruncatedTotal(mTotal) + "M";
        }
        if (total >= 1000L || total <= -1000L) {
            double kTotal = (double)total / 1000.0;
            return this.getTruncatedTotal(kTotal) + "K";
        }
        return this.getExactFormattedGp(total);
    }

    private String getTruncatedTotal(double total) {
        String totalString = Double.toString(total);
        int dotIndex = totalString.indexOf(46);
        if (dotIndex < totalString.length() - 1) {
            return totalString.substring(0, dotIndex + 2);
        }
        return totalString;
    }

    private String getExactFormattedGp(long total) {
        return NumberFormat.getInstance(Locale.ENGLISH).format(total);
    }

    private String getFormattedRunTime() {
        long runTime = this.plugin.elapsedRunTime();
        if (runTime == -1L) {
            return null;
        }
        long totalSecs = runTime / 1000L;
        long totalMins = totalSecs / 60L;
        long hrs = totalMins / 60L;
        long mins = totalMins % 60L;
        long secs = totalSecs % 60L;
        if (hrs > 0L) {
            return String.format(PROFIT_LOSS_TIME_FORMAT, hrs, mins, secs);
        }
        return String.format(PROFIT_LOSS_TIME_NO_HOURS_FORMAT, mins, secs);
    }

    public ItemContainer getInventoryItemContainer() {
        return this.inventoryItemContainer;
    }

    public ItemContainer getEquipmentItemContainer() {
        return this.equipmentItemContainer;
    }

    public void showInterstitial() {
        this.showInterstitial = true;
    }

    public void hideInterstitial() {
        this.showInterstitial = false;
    }
}

