/*
 * Decompiled with CFR 0.152.
 */
package com.charges;

import com.charges.ChargeCalc;
import com.charges.ChargeConfig;
import com.google.inject.Provides;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.VarClientIntChanged;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Charge Calculator")
public class ChargePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ChargePlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    private ChargeCalc set_amount;
    @Inject
    private ChargeConfig config;

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
    }

    @Subscribe
    public void onVarClientIntChanged(VarClientIntChanged event) {
        if (event.getIndex() != 5 || this.client.getVarcIntValue(5) != 7) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            this.set_amount = new ChargeCalc(this.client.getWidget(WidgetInfo.CHATBOX_CONTAINER), this.client);
            String title = this.client.getWidget(WidgetInfo.CHATBOX_TITLE).getText();
            Pattern title_pattern = Pattern.compile("How many charges (do|would) you (like|wish|want) to (add|apply)?");
            Matcher title_matcher = title_pattern.matcher(title);
            if (title_matcher.find()) {
                Pattern pattern = Pattern.compile("(\\d+(,\\d+)*)?\\)");
                Matcher matcher = pattern.matcher(title);
                if (matcher.find()) {
                    int amount = Integer.parseInt(matcher.group(1).replace(",", ""));
                    this.set_amount.showWidget(this.config.amount(), amount);
                } else {
                    System.out.println("Could not find pattern");
                }
            }
        });
    }

    @Provides
    ChargeConfig provideConfig(ConfigManager configManager) {
        return (ChargeConfig)configManager.getConfig(ChargeConfig.class);
    }
}

