/*
 * Decompiled with CFR 0.152.
 */
package com.prestige.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import net.runelite.api.Skill;

public enum SkillModel {
    CONSTRUCTION1(Skill.CONSTRUCTION, 2376, 10, 14, 669, 0, 15, 329),
    CONSTRUCTION2(Skill.CONSTRUCTION, 12309, 11, 14, 615, 0, 111, 451),
    COOKING(Skill.COOKING, 27611, 31, 59, 169, 0, 1593, 963),
    CRAFTING1(Skill.CRAFTING, 2376, 30, 24, 418, 0, 14, 496),
    CRAFTING2(Skill.CRAFTING, 2489, 39, 45, 353, 0, 18, 400),
    DEFENCE(Skill.DEFENCE, 2339, 34, 37, 337, 0, 1074, 598),
    FARMING(Skill.FARMING, 7331, 31, 52, 118, 0, 1278, 451),
    FIREMAKING(Skill.FIREMAKING, 2260, 29, 55, 115, 0, 1689, 771),
    FISHING(Skill.FISHING, 2355, 33, 30, 351, 0, 1865, 517),
    FLETCHING1(Skill.FLETCHING, 2711, 43, 19, 254, 0, 1257, 408),
    FLETCHING2(Skill.FLETCHING, 2711, 46, 44, 223, 0, 177, 444),
    HERBLORE(Skill.HERBLORE, 2364, 20, 35, 550, 0, 2024, 344),
    HITPOINTS(Skill.HITPOINTS, 3326, 35, 58, 538, 0, 0, 250),
    MAGIC(Skill.MAGIC, 2483, 29, 50, 131, 0, 1913, 344),
    MINING(Skill.MINING, 2529, 38, 33, 292, 0, 1166, 413),
    PRAYER(Skill.PRAYER, 3325, 29, 27, 582, 0, 504, 505),
    RANGED1(Skill.RANGED, 2711, 28, 34, 206, 0, 195, 405),
    RANGED2(Skill.RANGED, 2562, 42, 17, 422, 0, 1618, 397),
    RUNECRAFT(Skill.RUNECRAFT, 2349, 35, 38, 242, 0, 1979, 328),
    SLAYER(Skill.SLAYER, 1733, 34, 60, 221, 0, 1944, 649),
    SMITHING(Skill.SMITHING, 1251, 34, 53, 97, 0, 1868, 716),
    STRENGTH(Skill.STRENGTH, 3327, 35, 23, 512, 0, 14, 631),
    AGILITY(Skill.AGILITY, 3328, 29, 29, 533, 0, 2040, 685),
    THIEVING(Skill.THIEVING, 2500, 42, 31, 366, 0, 55, 155),
    WOODCUTTING(Skill.WOODCUTTING, 1570, 20, 69, 116, 0, 1978, 1800),
    ATTACK1(Skill.ATTACK, 2604, 65, 38, 234, 0, 148, 444),
    ATTACK2(Skill.ATTACK, 2602, 27, 29, 198, 0, 1419, 330),
    HUNTER(Skill.HUNTER, 19980, 45, 48, 512, 0, 0, 1000);

    private static final ListMultimap<Skill, SkillModel> SKILL_MODELS;
    private final Skill skill;
    private final int modelId;
    private final int originalX;
    private final int originalY;
    private final int rotationX;
    private final int rotationY;
    private final int rotationZ;
    private final int modelZoom;
    private final int iconWidth;
    private final int iconHeight;

    private SkillModel(Skill skill, int modelId, int originalX, int originalY, int rotationX, int rotationY, int rotationZ, int modelZoom) {
        this.skill = skill;
        this.modelId = modelId;
        this.originalX = originalX;
        this.originalY = originalY;
        this.rotationX = rotationX;
        this.rotationY = rotationY;
        this.rotationZ = rotationZ;
        this.modelZoom = modelZoom;
        this.iconWidth = skill == Skill.CONSTRUCTION ? 49 : 32;
        this.iconHeight = skill == Skill.CONSTRUCTION ? 61 : 32;
    }

    public static List<SkillModel> getSKILL_MODELS(Skill skill) {
        return SKILL_MODELS.get((Object)skill);
    }

    public Skill getSkill() {
        return this.skill;
    }

    public int getModelId() {
        return this.modelId;
    }

    public int getOriginalX() {
        return this.originalX;
    }

    public int getOriginalY() {
        return this.originalY;
    }

    public int getRotationX() {
        return this.rotationX;
    }

    public int getRotationY() {
        return this.rotationY;
    }

    public int getRotationZ() {
        return this.rotationZ;
    }

    public int getModelZoom() {
        return this.modelZoom;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    static {
        SKILL_MODELS = ArrayListMultimap.create();
        for (SkillModel skillModel : SkillModel.values()) {
            SKILL_MODELS.put((Object)skillModel.skill, (Object)skillModel);
        }
    }
}

