/*
 * Decompiled with CFR 0.152.
 */
package com.prestige.levelUp;

import com.prestige.PrestigePlugin;
import com.prestige.levelUp.LevelUpFireworks;
import com.prestige.model.SkillModel;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.List;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.game.chatbox.ChatboxInput;
import net.runelite.client.input.KeyListener;

public class LevelUpDisplayInput
extends ChatboxInput
implements KeyListener {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 16;
    private final PrestigePlugin plugin;
    private final Skill skill;
    private final int level;
    private boolean closeMessage;

    public LevelUpDisplayInput(PrestigePlugin plugin, Skill skill, int level) {
        this.plugin = plugin;
        this.skill = skill;
        this.level = level;
    }

    public void open() {
        String levelUpMessage;
        Widget chatboxContainer = this.plugin.getChatboxPanelManager().getContainerWidget();
        String skillName = this.skill.getName();
        int skillExperience = this.plugin.getClient().getSkillExperience(this.skill);
        List<SkillModel> skillModels = SkillModel.getSKILL_MODELS(this.skill);
        String prefix = this.skill == Skill.AGILITY || this.skill == Skill.ATTACK ? "an " : "a ";
        Widget levelUpHeader = chatboxContainer.createChild(-1, 4);
        Widget levelUpText = chatboxContainer.createChild(-1, 4);
        Widget levelUpContinue = chatboxContainer.createChild(-1, 4);
        if (skillExperience >= 200000000) {
            this.plugin.getClientThread().invoke(() -> this.setFireworksGraphic(LevelUpFireworks.NINETY_NINE));
            levelUpMessage = "Congratulations, you just maxed your " + skillName + " skill.";
        } else {
            this.plugin.getClientThread().invoke(() -> this.setFireworksGraphic(LevelUpFireworks.NORMAL));
            levelUpMessage = "Congratulations, you just advanced " + prefix + skillName + " prestige level.";
        }
        levelUpHeader.setText(levelUpMessage);
        levelUpHeader.setTextColor(Color.BLUE.getRGB());
        levelUpHeader.setFontId(497);
        levelUpHeader.setXPositionMode(0);
        levelUpHeader.setOriginalX(86);
        levelUpHeader.setYPositionMode(0);
        levelUpHeader.setOriginalY(31);
        levelUpHeader.setOriginalWidth(390);
        levelUpHeader.setOriginalHeight(30);
        levelUpHeader.setXTextAlignment(1);
        levelUpHeader.setYTextAlignment(0);
        levelUpHeader.setWidthMode(0);
        levelUpHeader.revalidate();
        String levelUpTextMessage = skillExperience == 200000000 ? "You have reached maximum experience in " + skillName : (this.skill == Skill.HITPOINTS ? "Your Hitpoints prestige is now " + this.level : "Your " + skillName + " prestige level is now " + this.level) + ".";
        levelUpText.setText(levelUpTextMessage);
        levelUpText.setFontId(497);
        levelUpText.setXPositionMode(0);
        levelUpText.setOriginalX(86);
        levelUpText.setYPositionMode(0);
        levelUpText.setOriginalY(60);
        levelUpText.setOriginalWidth(390);
        levelUpText.setOriginalHeight(30);
        levelUpText.setXTextAlignment(1);
        levelUpText.setYTextAlignment(0);
        levelUpText.setWidthMode(0);
        levelUpText.revalidate();
        levelUpContinue.setText("Click here to continue");
        levelUpContinue.setTextColor(Color.BLUE.getRGB());
        levelUpContinue.setFontId(497);
        levelUpContinue.setXPositionMode(0);
        levelUpContinue.setOriginalX(86);
        levelUpContinue.setYPositionMode(0);
        levelUpContinue.setOriginalY(90);
        levelUpContinue.setOriginalWidth(390);
        levelUpContinue.setOriginalHeight(17);
        levelUpContinue.setXTextAlignment(1);
        levelUpContinue.setYTextAlignment(0);
        levelUpContinue.setWidthMode(0);
        levelUpContinue.setAction(0, "Continue");
        levelUpContinue.setOnOpListener(new Object[]{ev -> this.triggerCloseViaMessage()});
        levelUpContinue.setOnMouseOverListener(new Object[]{ev -> levelUpContinue.setTextColor(Color.WHITE.getRGB())});
        levelUpContinue.setOnMouseLeaveListener(new Object[]{ev -> levelUpContinue.setTextColor(Color.BLUE.getRGB())});
        levelUpContinue.setHasListener(true);
        levelUpContinue.revalidate();
        for (SkillModel skillModel : skillModels) {
            LevelUpDisplayInput.buildWidgetModel(chatboxContainer, skillModel);
        }
        this.plugin.getChatMessageManager().queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(skillExperience == 200000000 ? "Congratulations, you've just reached max experience in " + skillName + "!" : "Congratulations, you've just advanced your " + skillName + " prestige level. You are now prestige level " + this.level + ".").build());
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() != ' ') {
            return;
        }
        this.triggerCloseViaMessage();
        e.consume();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void closeIfTriggered() {
        if (this.closeMessage && this.plugin.getChatboxPanelManager().getCurrentInput() == this) {
            this.plugin.getChatboxPanelManager().close();
        }
    }

    void triggerClose() {
        this.closeMessage = true;
    }

    private void triggerCloseViaMessage() {
        Widget levelUpContinue = this.plugin.getClient().getWidget(WidgetInfo.CHATBOX_CONTAINER).getChild(2);
        levelUpContinue.setText("Please wait...");
        this.closeMessage = true;
    }

    private static void buildWidgetModel(Widget chatboxContainer, SkillModel model) {
        Widget levelUpModel = chatboxContainer.createChild(-1, 6);
        levelUpModel.setModelId(model.getModelId());
        levelUpModel.setXPositionMode(0);
        levelUpModel.setOriginalX(model.getOriginalX() + 13);
        levelUpModel.setYPositionMode(0);
        levelUpModel.setOriginalY(model.getOriginalY() + 16);
        levelUpModel.setOriginalWidth(model.getIconWidth());
        levelUpModel.setOriginalHeight(model.getIconHeight());
        levelUpModel.setRotationX(model.getRotationX());
        levelUpModel.setRotationY(model.getRotationY());
        levelUpModel.setRotationZ(model.getRotationZ());
        levelUpModel.setModelZoom(model.getModelZoom());
        levelUpModel.revalidate();
    }

    private void setFireworksGraphic(LevelUpFireworks firework) {
        Player localPlayer = this.plugin.getClient().getLocalPlayer();
        if (localPlayer == null) {
            return;
        }
        int fireworksGraphic = firework.getGraphicId();
        if (fireworksGraphic == -1) {
            return;
        }
        localPlayer.setGraphic(fireworksGraphic);
        localPlayer.setSpotAnimFrame(0);
    }

    public boolean isCloseMessage() {
        return this.closeMessage;
    }
}

