/*
 * Decompiled with CFR 0.152.
 */
package com.prestige;

import com.google.inject.Provides;
import com.prestige.PrestigeConfig;
import com.prestige.levelUp.LevelUpDisplayInput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.Skill;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.events.StatChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.chatbox.ChatboxInput;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Prestige", description="Resets xp to 0 and doubles xp rate between levels 92 and 99", tags={"levelling", "reset", "99", "92"})
public class PrestigePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PrestigePlugin.class);
    private static final String TOTAL_LEVEL_TEXT_PREFIX = "Total level:<br>";
    private int xpFactor = 2;
    private int maxXp = Experience.getXpForLevel((int)99);
    private int prestigeXP = this.maxXp - this.maxXp / this.xpFactor;
    private static final List<Skill> COMBAT_SKILLS = Arrays.asList(Skill.ATTACK, Skill.DEFENCE, Skill.STRENGTH, Skill.MAGIC, Skill.RANGED);
    private static final Map<Skill, Integer> ACTUAL_SKILL_XP = new HashMap<Skill, Integer>();
    private static final Map<Skill, Integer> ACTUAL_SKILL_BOOST = new HashMap<Skill, Integer>();
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private PrestigeConfig config;
    private LevelUpDisplayInput input;
    private final Map<Skill, Integer> updatedSkills = new HashMap<Skill, Integer>();
    private final List<Skill> levelledSkills = new ArrayList<Skill>();

    @Provides
    PrestigeConfig provideConfig(ConfigManager configManager) {
        return (PrestigeConfig)configManager.getConfig(PrestigeConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.input != null) {
            this.input.closeIfTriggered();
        }
        if (this.levelledSkills.isEmpty() || !this.chatboxPanelManager.getContainerWidget().isHidden()) {
            return;
        }
        Skill skill = this.levelledSkills.remove(0);
        int xp = this.client.getSkillExperience(skill);
        if (this.isPrestiged(xp)) {
            xp = this.prestigeXP(xp);
        }
        this.input = new LevelUpDisplayInput(this, skill, Experience.getLevelForXp((int)xp));
        this.chatboxPanelManager.openInput((ChatboxInput)this.input);
    }

    protected void shutDown() {
        this.resetSkills();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("prestige")) {
            return;
        }
        this.calculatePrestigeRange();
        this.resetSkills();
        this.updateAllStats();
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent e) {
        String[] stringStack = this.client.getStringStack();
        int stringStackSize = this.client.getStringStackSize();
        switch (e.getEventName()) {
            case "skillTabTotalLevel": {
                int level = 0;
                for (Skill s : Skill.values()) {
                    if (s == Skill.OVERALL) continue;
                    level += Experience.getLevelForXp((int)this.client.getSkillExperience(s));
                }
                stringStack[stringStackSize - 1] = TOTAL_LEVEL_TEXT_PREFIX + level;
            }
        }
    }

    protected void startUp() {
        for (Skill skill : Skill.values()) {
            if (skill == Skill.OVERALL) continue;
            ACTUAL_SKILL_XP.put(skill, this.client.getSkillExperience(skill));
            ACTUAL_SKILL_BOOST.put(skill, this.client.getBoostedSkillLevel(skill));
        }
        this.calculatePrestigeRange();
        this.updateAllStats();
    }

    private void updateAllStats() {
        for (Skill skill : Skill.values()) {
            if (skill == Skill.OVERALL) continue;
            this.changeStat(skill, this.client.getRealSkillLevel(skill), ACTUAL_SKILL_BOOST.get(skill), true);
            this.client.queueChangedSkill(skill);
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        this.changeStat(statChanged.getSkill(), statChanged.getLevel(), statChanged.getBoostedLevel(), false);
    }

    private void resetSkills() {
        for (Skill skill : Skill.values()) {
            if (skill == Skill.OVERALL) continue;
            int xp = ACTUAL_SKILL_XP.get(skill);
            this.client.getRealSkillLevels()[skill.ordinal()] = Experience.getLevelForXp((int)xp);
            this.client.getSkillExperiences()[skill.ordinal()] = xp;
            this.client.getBoostedSkillLevels()[skill.ordinal()] = ACTUAL_SKILL_BOOST.get(skill);
            this.client.queueChangedSkill(skill);
        }
    }

    private void changeStat(Skill skill, int level, int boostedLevel, boolean ignoreLevels) {
        int xp = this.client.getSkillExperience(skill);
        ACTUAL_SKILL_XP.put(skill, xp);
        ACTUAL_SKILL_BOOST.put(skill, boostedLevel);
        if (COMBAT_SKILLS.contains(skill) ? !this.config.enableCombat() : (Skill.HITPOINTS == skill ? !this.config.enableHP() : (Skill.PRAYER == skill ? !this.config.enablePrayer() : !this.config.enableNonCombat()))) {
            return;
        }
        if (this.isPrestiged(xp) && (!this.config.showRealLevels() || this.isPrestigeLevelCloser(xp))) {
            int oldLevel;
            int prestigeXp = this.prestigeXP(xp);
            int newLevel = Experience.getLevelForXp((int)prestigeXp);
            int boostDiff = boostedLevel - Experience.getLevelForXp((int)ACTUAL_SKILL_XP.get(skill));
            this.client.getRealSkillLevels()[skill.ordinal()] = newLevel;
            this.client.getSkillExperiences()[skill.ordinal()] = prestigeXp;
            this.client.getBoostedSkillLevels()[skill.ordinal()] = newLevel + boostDiff;
            int n = oldLevel = this.updatedSkills.get(skill) != null ? this.updatedSkills.get(skill) : level;
            if (!ignoreLevels && oldLevel < newLevel) {
                this.levelledSkills.add(skill);
            }
            this.updatedSkills.put(skill, newLevel);
        }
    }

    private boolean isPrestiged(int xp) {
        return xp > this.prestigeXP && xp < this.maxXp;
    }

    private boolean isPrestigeLevelCloser(int xp) {
        int prestigeXp = this.prestigeXP(xp);
        int level = Experience.getLevelForXp((int)xp);
        int remaining = Experience.getXpForLevel((int)(level + 1)) - xp;
        int prestigeRemaining = Experience.getXpForLevel((int)(Experience.getLevelForXp((int)prestigeXp) + 1)) - prestigeXp;
        return prestigeRemaining / this.xpFactor < remaining;
    }

    private int prestigeXP(int xp) {
        return (xp - this.prestigeXP) * this.xpFactor;
    }

    private void calculatePrestigeRange() {
        this.xpFactor = this.config.xpFactor();
        this.maxXp = Experience.getXpForLevel((int)this.config.goalLevel());
        this.prestigeXP = this.maxXp - this.maxXp / this.xpFactor;
    }

    public Client getClient() {
        return this.client;
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public ChatboxPanelManager getChatboxPanelManager() {
        return this.chatboxPanelManager;
    }

    public ChatMessageManager getChatMessageManager() {
        return this.chatMessageManager;
    }
}

