/*
 * Decompiled with CFR 0.152.
 */
package com.toblightcolors;

import com.google.inject.Provides;
import com.toblightcolors.TobLightColorsConfig;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.JagexColor;
import net.runelite.api.Model;
import net.runelite.api.ModelData;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ToB Light Colors", description="Recolors the ToB chest and adds a light beam above the chest")
public class TobLightColorsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TobLightColorsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private TobLightColorsConfig config;
    private static final int YOUR_TOB_CHEST_PURPLE_OBJ = 32993;
    private static final int YOUR_TOB_CHEST_NORMAL_OBJ = 32992;
    private static final int OTHER_TOB_CHEST_PURPLE_OBJ = 32991;
    private static final int OTHER_TOB_CHEST_NORMAL_OBJ = 32990;
    private static final List<Integer> REWARD_CHEST_IDS = Arrays.asList(33086, 33087, 33088, 33089, 33090);
    private static final int PURPLE_HSL_COLOR_LOW = 55000;
    private static final int PURPLE_HSL_COLOR_HIGH = 55500;
    private static final int LIGHT_BEAM_MODEL = 5809;
    private Map<Integer, RuneLiteObject> lightBeamsObjects = new HashMap<Integer, RuneLiteObject>();

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
        this.clientThread.invokeLater(() -> {
            this.clearAllLightBeams();
            return true;
        });
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        int objId = event.getGameObject().getId();
        if (REWARD_CHEST_IDS.contains(objId)) {
            int impostorId = this.client.getObjectDefinition(objId).getImpostor().getId();
            Model tobChestModel = event.getGameObject().getRenderable().getModel();
            LocalPoint tobChestPoint = event.getGameObject().getLocalLocation();
            if (impostorId == 32993) {
                if (this.config.enableRecolorYour()) {
                    this.recolorTobChest(tobChestModel, this.config.uniqueColorYour());
                }
                if (this.config.enableUniqueLightBeamYour()) {
                    this.spawnLightBeam(tobChestPoint, this.config.uniqueColorYour(), objId);
                }
            } else if (impostorId == 32991) {
                if (this.config.enableRecolorOther()) {
                    this.recolorTobChest(tobChestModel, this.config.uniqueColorOther());
                }
                if (this.config.enableUniqueLightBeamOther()) {
                    this.spawnLightBeam(tobChestPoint, this.config.uniqueColorOther(), objId);
                }
            } else if (impostorId == 32992) {
                if (this.config.enableStandardLightBeamYour()) {
                    this.spawnLightBeam(tobChestPoint, this.config.standardColorYour(), objId);
                }
            } else if (impostorId == 32990 && this.config.enableStandardLightBeamOther()) {
                this.spawnLightBeam(tobChestPoint, this.config.standardColorOther(), objId);
            }
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        int objId = event.getGameObject().getId();
        if (this.lightBeamsObjects.containsKey(objId)) {
            this.lightBeamsObjects.get(objId).setActive(false);
            this.lightBeamsObjects.remove(objId);
        }
    }

    private void spawnLightBeam(LocalPoint point, Color color, int objId) {
        RuneLiteObject lightBeam = this.client.createRuneLiteObject();
        ModelData lightBeamModel = ((ModelData)((ModelData)this.client.loadModelData(5809).cloneVertices().translate(0, -100, 0)).scale(240, 200, 240)).cloneColors();
        lightBeamModel.recolor(lightBeamModel.getFaceColors()[0], JagexColor.rgbToHSL((int)color.getRGB(), (double)1.0));
        lightBeam.setModel(lightBeamModel.light());
        if (this.config.enableLightAnimation()) {
            lightBeam.setAnimation(this.client.loadAnimation(3101));
            lightBeam.setShouldLoop(true);
        }
        lightBeam.setLocation(point, this.client.getPlane());
        lightBeam.setActive(true);
        this.lightBeamsObjects.put(objId, lightBeam);
    }

    private void clearAllLightBeams() {
        for (Map.Entry<Integer, RuneLiteObject> entry : this.lightBeamsObjects.entrySet()) {
            entry.getValue().setActive(false);
        }
        this.lightBeamsObjects.clear();
    }

    private void recolorTobChest(Model tobChestModel, Color color) {
        int replacementColor = this.colorToRs2hsb(color);
        int[] faceColors1 = tobChestModel.getFaceColors1();
        for (int i = 0; i < faceColors1.length; ++i) {
            if (faceColors1[i] <= 55000 || faceColors1[i] >= 55500) continue;
            faceColors1[i] = replacementColor;
        }
    }

    private int colorToRs2hsb(Color color) {
        float[] hsbVals = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        hsbVals[2] = hsbVals[2] - Math.min(hsbVals[1], hsbVals[2] / 2.0f);
        int encode_hue = (int)(hsbVals[0] * 63.0f);
        int encode_saturation = (int)(hsbVals[1] * 7.0f);
        int encode_brightness = (int)(hsbVals[2] * 127.0f);
        return (encode_hue << 10) + (encode_saturation << 7) + encode_brightness;
    }

    @Provides
    TobLightColorsConfig provideConfig(ConfigManager configManager) {
        return (TobLightColorsConfig)configManager.getConfig(TobLightColorsConfig.class);
    }
}

