/*
 * Decompiled with CFR 0.152.
 */
package com.chatsounds;

import com.chatsounds.ChatSoundsConfig;
import com.chatsounds.ChatSoundsMode;
import com.google.inject.Provides;
import jaco.mp3.player.MP3Player;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Chat Sounds")
public class ChatSoundsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ChatSoundsPlugin.class);
    private static final String CS_CLAN_MSG = "To talk in your clan's channel, start each line of chat with // or /c.";
    private static final File CS_DIR = new File(RuneLite.RUNELITE_DIR.getPath() + File.separator + "chat-sounds");
    private static final File CS_DEFAULT = new File(CS_DIR, "cs_default.mp3");
    private static final File CS_PUBLIC = new File(CS_DIR, "cs_public.mp3");
    private static final File CS_PRIVATE = new File(CS_DIR, "cs_private.mp3");
    private static final File CS_CHAT_CHANNEL = new File(CS_DIR, "cs_chat_channel.mp3");
    private static final File CS_CLAN = new File(CS_DIR, "cs_clan.mp3");
    private static final File CS_CLAN_BROADCAST = new File(CS_DIR, "cs_clan_broadcast.mp3");
    private static final File[] CS_FILES = new File[]{CS_DEFAULT, CS_PUBLIC, CS_PRIVATE, CS_CHAT_CHANNEL, CS_CLAN, CS_CLAN_BROADCAST};
    @Inject
    private Client client;
    @Inject
    private ChatSoundsConfig config;

    protected void startUp() {
        this.initSoundFiles();
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Player player = this.client.getLocalPlayer();
        String eventName = this.removePrefixedImageFromName(event.getName());
        if (player == null || this.client.getGameState() != GameState.LOGGED_IN || eventName.equals(player.getName())) {
            return;
        }
        ChatMessageType type = event.getType();
        switch (type) {
            case MODCHAT: 
            case PUBLICCHAT: {
                this.playSound(this.config.publicChat(), CS_PUBLIC);
                break;
            }
            case MODPRIVATECHAT: 
            case PRIVATECHAT: {
                this.playSound(this.config.privateChat(), CS_PRIVATE);
                break;
            }
            case FRIENDSCHAT: {
                this.playSound(this.config.chatChannel(), CS_CHAT_CHANNEL);
                break;
            }
            case CLAN_CHAT: {
                this.playSound(this.config.clanChat(), CS_CLAN);
                break;
            }
            case CLAN_MESSAGE: {
                if (event.getMessage().equals(CS_CLAN_MSG)) break;
                this.playSound(this.config.clanBroadcast(), CS_CLAN_BROADCAST);
            }
        }
    }

    private String removePrefixedImageFromName(String text) {
        boolean hasTextAfterMarkup;
        boolean startsWithImgMarkup = text.startsWith("<img") && text.contains(">");
        boolean bl = hasTextAfterMarkup = text.indexOf(">") != text.length() - 1;
        if (startsWithImgMarkup && hasTextAfterMarkup) {
            text = text.substring(text.indexOf(">") + 1);
        }
        return text;
    }

    private void initSoundFiles() {
        if (!CS_DIR.exists()) {
            CS_DIR.mkdirs();
        }
        for (File f : CS_FILES) {
            try {
                int bytesRead;
                if (f.exists()) continue;
                InputStream stream = ChatSoundsPlugin.class.getClassLoader().getResourceAsStream("cs_default.mp3");
                FileOutputStream out = new FileOutputStream(f);
                byte[] buffer = new byte[8192];
                while ((bytesRead = stream.read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, bytesRead);
                }
                ((OutputStream)out).close();
                stream.close();
            }
            catch (Exception e) {
                log.info("ChatSoundsPlugin - " + e + ": " + f);
            }
        }
    }

    private void playSound(ChatSoundsMode mode, File f) {
        if (mode == ChatSoundsMode.OFF || !f.exists()) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            MP3Player mp3Player = new MP3Player(CS_DEFAULT);
            if (mode == ChatSoundsMode.CUSTOM) {
                mp3Player = new MP3Player(f);
            }
            mp3Player.setVolume(this.config.volume());
            mp3Player.play();
        });
    }

    @Provides
    ChatSoundsConfig provideConfig(ConfigManager configManager) {
        return (ChatSoundsConfig)configManager.getConfig(ChatSoundsConfig.class);
    }
}

