/*
 * Decompiled with CFR 0.152.
 */
package com.chatsounds;

import com.chatsounds.ChatSoundsMode;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="chatSounds")
public interface ChatSoundsConfig
extends Config {
    @ConfigItem(keyName="publicChat", name="Public Chat", description="The sound effect to use when receiving a public chat message.", position=1)
    default public ChatSoundsMode publicChat() {
        return ChatSoundsMode.OFF;
    }

    @ConfigItem(keyName="privateChat", name="Private Chat", description="The sound effect to use when receiving a private chat message.", position=2)
    default public ChatSoundsMode privateChat() {
        return ChatSoundsMode.DEFAULT;
    }

    @ConfigItem(keyName="chatChannel", name="Chat-channel", description="The sound effect to use when receiving a chat-channel chat message.", position=3)
    default public ChatSoundsMode chatChannel() {
        return ChatSoundsMode.OFF;
    }

    @ConfigItem(keyName="clanChat", name="Clan Chat", description="The sound effect to use when receiving a clan chat message.", position=4)
    default public ChatSoundsMode clanChat() {
        return ChatSoundsMode.OFF;
    }

    @ConfigItem(keyName="clanBroadcast", name="Clan Broadcast", description="The sound effect to use when receiving a clan broadcast message.", position=5)
    default public ChatSoundsMode clanBroadcast() {
        return ChatSoundsMode.OFF;
    }

    @Range(max=100)
    @Units(value="%")
    @ConfigItem(keyName="volume", name="Volume", description="Sets the volume of the chat message sound effect.", position=10)
    default public int volume() {
        return 100;
    }
}

