/*
 * Decompiled with CFR 0.152.
 */
package com.vanillj.xptolevelnotification;

import com.google.inject.Provides;
import com.vanillj.xptolevelnotification.XpToLevelNotificationConfig;
import java.time.Instant;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.events.StatChanged;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Xp To Level Notification")
public class XpToLevelNotificationPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(XpToLevelNotificationPlugin.class);
    private int xpThreshold;
    private int notificationDelay;
    private HashMap<String, Instant> skillDelay;
    @Inject
    private Client client;
    @Inject
    private XpToLevelNotificationConfig config;
    @Inject
    private Notifier notifier;

    protected void startUp() throws Exception {
        this.xpThreshold = this.config.xpThreshold();
        this.notificationDelay = 60 * this.config.xpNotificationDelay();
        this.skillDelay = new HashMap();
    }

    protected void shutDown() throws Exception {
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        String skillName = statChanged.getSkill().getName();
        if (!this.skillDelay.containsKey(skillName)) {
            this.skillDelay.put(skillName, Instant.now().plusSeconds(-1L));
            return;
        }
        int currentXp = statChanged.getXp();
        int currentLevel = Experience.getLevelForXp((int)currentXp);
        int xpNextLevel = currentLevel + 1 <= 126 ? Experience.getXpForLevel((int)(currentLevel + 1)) : 200000000;
        int xpDelta = xpNextLevel - currentXp;
        if (Instant.now().isBefore(this.skillDelay.get(skillName))) {
            return;
        }
        if (xpDelta < this.xpThreshold) {
            this.skillDelay.put(skillName, Instant.now().plusSeconds(this.notificationDelay));
            log.debug("Next notification time: " + Instant.now().plusSeconds(this.notificationDelay).toString());
            this.notifier.notify("XP left to level: " + xpDelta + " in " + skillName);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("xptolevelnotification")) {
            return;
        }
        if (this.config.xpThreshold() != this.xpThreshold) {
            this.xpThreshold = this.config.xpThreshold();
        }
        if (this.config.xpNotificationDelay() != this.notificationDelay) {
            this.notificationDelay = 60 * this.config.xpNotificationDelay();
            this.skillDelay.clear();
        }
    }

    @Provides
    XpToLevelNotificationConfig provideConfig(ConfigManager configManager) {
        return (XpToLevelNotificationConfig)configManager.getConfig(XpToLevelNotificationConfig.class);
    }
}

