/*
 * Decompiled with CFR 0.152.
 */
package com.ironvalue;

import com.ironvalue.IronValueConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.QuantityFormatter;

class IronValueOverlay
extends Overlay {
    private static final int INVENTORY_ITEM_WIDGETID = WidgetInfo.INVENTORY.getPackedId();
    private static final int BANK_INVENTORY_ITEM_WIDGETID = WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER.getPackedId();
    private static final int BANK_ITEM_WIDGETID = WidgetInfo.BANK_ITEM_CONTAINER.getPackedId();
    private static final int EXPLORERS_RING_ITEM_WIDGETID = WidgetInfo.EXPLORERS_RING_ALCH_INVENTORY.getPackedId();
    private static final int SEED_VAULT_ITEM_WIDGETID = WidgetInfo.SEED_VAULT_ITEM_CONTAINER.getPackedId();
    private static final int SEED_VAULT_INVENTORY_ITEM_WIDGETID = WidgetInfo.SEED_VAULT_INVENTORY_ITEMS_CONTAINER.getPackedId();
    private static final int POH_TREASURE_CHEST_INVENTORY_ITEM_WIDGETID = WidgetInfo.POH_TREASURE_CHEST_INVENTORY_CONTAINER.getPackedId();
    private static final int BLOOD_RUNE_GP_SALE_PRICE = 200;
    private static final int DEATH_RUNE_GP_SALE_PRICE = 90;
    private static final int CHAOS_RUNE_TOKKUL_SALE_PRICE = 9;
    private static final int DEATH_RUNE_TOKKUL_SALE_PRICE = 18;
    private static final int MINNOWS_PER_SHARK = 40;
    private static final int STAMINAS_PER_GRACE = 10;
    private static final int GRACE_PER_EXCHANGE = 10;
    private static final int AMYLASE_PER_EXCHANGE = 100;
    private final Client client;
    private final IronValueConfig config;
    private final TooltipManager tooltipManager;
    private final StringBuilder stringBuilder = new StringBuilder();
    @Inject
    ItemManager itemManager;

    @Inject
    IronValueOverlay(Client client, IronValueConfig config, TooltipManager tooltipManager) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.client = client;
        this.config = config;
        this.tooltipManager = tooltipManager;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.client.isMenuOpen()) {
            return null;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int last = menuEntries.length - 1;
        if (last < 0) {
            return null;
        }
        MenuEntry menuEntry = menuEntries[last];
        MenuAction action = menuEntry.getType();
        int widgetId = menuEntry.getParam1();
        int groupId = WidgetInfo.TO_GROUP((int)widgetId);
        switch (action) {
            case WIDGET_TARGET_ON_WIDGET: {
                if (menuEntry.getWidget().getId() != WidgetInfo.INVENTORY.getId()) break;
            }
            case WIDGET_USE_ON_ITEM: 
            case CC_OP: 
            case ITEM_USE: 
            case ITEM_FIRST_OPTION: 
            case ITEM_SECOND_OPTION: 
            case ITEM_THIRD_OPTION: 
            case ITEM_FOURTH_OPTION: 
            case ITEM_FIFTH_OPTION: {
                this.addTooltip(menuEntry, groupId);
                break;
            }
            case WIDGET_TARGET: {
                if (menuEntry.getWidget().getId() != WidgetInfo.INVENTORY.getId()) break;
                this.addTooltip(menuEntry, groupId);
            }
        }
        return null;
    }

    private void addTooltip(MenuEntry menuEntry, int groupId) {
        switch (groupId) {
            case 12: 
            case 15: 
            case 149: 
            case 630: 
            case 631: 
            case 674: {
                String text = this.makeValueTooltip(menuEntry);
                if (text == null) break;
                this.tooltipManager.add(new Tooltip(ColorUtil.prependColorTag((String)text, (Color)new Color(238, 238, 238))));
            }
        }
    }

    private String makeValueTooltip(MenuEntry menuEntry) {
        int widgetId = menuEntry.getParam1();
        ItemContainer container = null;
        if (widgetId == INVENTORY_ITEM_WIDGETID || widgetId == BANK_INVENTORY_ITEM_WIDGETID || widgetId == EXPLORERS_RING_ITEM_WIDGETID || widgetId == SEED_VAULT_INVENTORY_ITEM_WIDGETID || widgetId == POH_TREASURE_CHEST_INVENTORY_ITEM_WIDGETID) {
            container = this.client.getItemContainer(InventoryID.INVENTORY);
        } else if (widgetId == BANK_ITEM_WIDGETID) {
            container = this.client.getItemContainer(InventoryID.BANK);
        } else if (widgetId == SEED_VAULT_ITEM_WIDGETID) {
            container = this.client.getItemContainer(InventoryID.SEED_VAULT);
        }
        if (container == null) {
            return null;
        }
        int index = menuEntry.getParam0();
        Item item = container.getItem(index);
        if (item != null) {
            return this.getItemStackValueText(item);
        }
        return null;
    }

    private void addLineToOutput(String line) {
        if (this.stringBuilder.length() > 0) {
            this.stringBuilder.append("</br>");
        }
        this.stringBuilder.append(line);
    }

    private String getItemStackValueText(Item item) {
        int id = this.itemManager.canonicalize(item.getId());
        int qty = item.getQuantity();
        this.stringBuilder.setLength(0);
        if (id == 565 && this.config.showBloodRuneShopPrice()) {
            this.addLineToOutput("Ali: " + QuantityFormatter.quantityToStackSize((long)((long)qty * 200L)) + " gp");
        }
        if (id == 560 && this.config.showDeathRuneShopPrice()) {
            this.addLineToOutput("Ali: " + QuantityFormatter.quantityToStackSize((long)((long)qty * 90L)) + " gp");
        }
        if (id == 21356 && this.config.showMinnowSharkConversion()) {
            this.addLineToOutput("Kylie: " + QuantityFormatter.quantityToStackSize((long)((long)qty / 40L)) + " sharks");
        }
        if (id == 11849 && this.config.showMarkOfGraceStaminaConversion()) {
            long true_amylase = (long)(Math.floor((double)qty / 10.0) * 100.0);
            double approximate_amylase = qty * 10;
            this.addLineToOutput("Grace: " + QuantityFormatter.quantityToStackSize((long)((long)approximate_amylase)) + " (" + QuantityFormatter.quantityToStackSize((long)true_amylase) + ") stamina doses");
        }
        if (id == 562 && this.config.showChaosRuneTokkulPrice()) {
            this.addLineToOutput("Mej-Roh: " + QuantityFormatter.quantityToStackSize((long)((long)qty * 9L)) + " tokkul");
        }
        if (id == 560 && this.config.showDeathRuneTokkulPrice()) {
            this.addLineToOutput("Mej-Roh: " + QuantityFormatter.quantityToStackSize((long)((long)qty * 18L)) + " tokkul");
        }
        if (this.stringBuilder.length() > 0) {
            String result = this.stringBuilder.toString();
            this.stringBuilder.setLength(0);
            return result;
        }
        return null;
    }
}

