/*
 * Decompiled with CFR 0.152.
 */
package com.camerafun;

public class EaseUtility {
    public double easeInSine(double x) {
        return 1.0 - Math.cos(x * Math.PI / 2.0 + 1.5707963267948966) - 1.0;
    }

    public double easeInOutSine(double x) {
        return -(Math.cos(Math.PI * x + 1.5707963267948966) - 1.0) / 2.0 - 0.5;
    }

    public double easeOutBounce(double x) {
        double n1 = 7.5625;
        double d1 = 2.75;
        int flip = x < 0.0 ? -1 : 1;
        if ((x = Math.abs(x)) < 1.0 / d1) {
            return n1 * x * x * (double)flip;
        }
        if (x < 2.0 / d1) {
            return (n1 * (x -= 1.5 / d1) * x + 0.75) * (double)flip;
        }
        if (x < 2.5 / d1) {
            return (n1 * (x -= 2.25 / d1) * x + 0.9375) * (double)flip;
        }
        return (n1 * (x -= 2.625 / d1) * x + 0.984375) * (double)flip;
    }

    public double easeOutBack(double x) {
        double c1 = 1.70158;
        double c3 = c1 + 1.0;
        int flip = x < 0.0 ? -1 : 1;
        x = Math.abs(x);
        return (1.0 + c3 * Math.pow(x - 1.0, 3.0) + c1 * Math.pow(x - 1.0, 2.0)) * (double)flip;
    }

    public double easeOutElastic(double x) {
        double c4 = 2.0943951023931953;
        int flip = x < 0.0 ? -1 : 1;
        return (x = Math.abs(x)) == 0.0 ? (double)(0 * flip) : (x == 1.0 ? (double)(1 * flip) : (Math.pow(2.0, -10.0 * x) * Math.sin((x * 10.0 - 0.75) * c4) + 1.0) * (double)flip);
    }
}

