/*
 * Decompiled with CFR 0.152.
 */
package com.camerafun;

import com.camerafun.CameraFunConfig;
import com.camerafun.EaseUtility;
import com.google.inject.Provides;
import java.awt.event.MouseEvent;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Camera Fun")
public class CameraFunPlugin
extends Plugin
implements MouseListener {
    private static final Logger log = LoggerFactory.getLogger(CameraFunPlugin.class);
    static final int period = 180;
    static final int fps = 60;
    static final double amplitude = 60.0;
    static final EaseUtility easeUtilities = new EaseUtility();
    @Inject
    private Client client;
    @Inject
    private CameraFunConfig config;
    @Inject
    private MouseManager mouseManager;
    private int yawCycle;
    private Instant loginTime;
    private double delta;
    private int last_time;
    private int pivotPoint;
    private boolean mouseActive;
    private int mouseDirection;
    private double mouseDistanceNormalized;
    private double mouseTimeNormalized;
    private boolean didMouseJustRelease;
    private int mouseStartTimestamp;
    private int mouseStartX;

    protected void startUp() throws Exception {
        this.mouseManager.registerMouseListener((MouseListener)this);
        this.yawCycle = 0;
        this.mouseDirection = 1;
        if (this.loginTime == null) {
            this.loginTime = Instant.now();
        }
        this.resetPivot();
    }

    protected void shutDown() throws Exception {
        this.mouseManager.unregisterMouseListener((MouseListener)this);
        this.resetPivot();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.loginTime = Instant.now();
        }
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        int timestamp = (int)(System.nanoTime() / 1000000L);
        double timestep = 1000.0 / (double)this.config.fps();
        this.delta += (double)(timestamp - this.last_time);
        this.last_time = timestamp;
        if (this.delta >= timestep) {
            if (!this.mouseActive) {
                Duration duration;
                double sin;
                double degree = (double)this.yawCycle++ / (double)this.config.period() * 360.0;
                double rad = Math.toRadians(degree);
                double yawShift = sin = Math.sin(rad);
                if (!this.config.infiniteLoop() && degree >= 90.0) {
                    this.mouseActive = true;
                    return;
                }
                switch (this.config.filterType()) {
                    case easeInSine: {
                        yawShift = easeUtilities.easeInSine(sin);
                        break;
                    }
                    case easeYoYo: {
                        yawShift = easeUtilities.easeInOutSine(sin);
                        break;
                    }
                    case easeOutBounce: {
                        yawShift = easeUtilities.easeOutBounce(sin);
                        break;
                    }
                    case easeOutBack: {
                        yawShift = easeUtilities.easeOutBack(sin);
                        break;
                    }
                    case easeOutElastic: {
                        yawShift = easeUtilities.easeOutElastic(sin);
                        break;
                    }
                }
                yawShift *= this.config.amplitude() * (double)(!this.config.infiniteLoop() ? 5 : 1) * (double)this.mouseDirection;
                if (this.config.highStaminaCondition()) {
                    yawShift *= (double)(this.client.getEnergy() / 10);
                }
                if (this.config.lowStaminaCondition()) {
                    yawShift *= (double)(100 / this.client.getEnergy());
                }
                if (this.config.lowGameTimeCondition()) {
                    duration = Duration.between(this.loginTime, Instant.now());
                    yawShift *= (double)(100L / duration.getSeconds());
                }
                if (this.config.highGameTimeCondition()) {
                    duration = Duration.between(this.loginTime, Instant.now());
                    yawShift += (double)duration.getSeconds();
                }
                double newYaw = (double)this.pivotPoint + yawShift * this.mouseDistanceNormalized * this.mouseTimeNormalized;
                if (this.didMouseJustRelease && this.config.infiniteLoop() && degree == 90.0) {
                    this.mouseDistanceNormalized = 1.0;
                    this.mouseTimeNormalized = 1.0;
                    this.didMouseJustRelease = false;
                    this.resetPivot();
                }
                if (newYaw < 0.0) {
                    newYaw = 2047.0 + newYaw;
                }
                if (newYaw > 2047.0) {
                    newYaw %= 2047.0;
                }
                this.client.setCameraYawTarget((int)newYaw);
            }
            this.delta -= timestep;
        }
    }

    public void resetPivot() {
        this.delta = 0.0;
        this.yawCycle = 0;
        this.pivotPoint = this.client.getCameraYaw();
    }

    public MouseEvent mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            this.resetPivot();
            this.mouseStartX = mouseEvent.getX();
            this.mouseStartTimestamp = (int)(System.nanoTime() / 1000000L);
            this.mouseActive = true;
        }
        return mouseEvent;
    }

    public MouseEvent mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            this.resetPivot();
            this.mouseDirection = this.mouseStartX < mouseEvent.getX() ? -1 : 1;
            int diff = (int)(System.nanoTime() / 1000000L) - this.mouseStartTimestamp;
            double buffer100ms = Math.max((double)diff, 0.0);
            this.mouseTimeNormalized = buffer100ms / 300.0;
            this.mouseDistanceNormalized = Math.abs((double)this.mouseStartX - (double)mouseEvent.getX()) / (double)this.client.getViewportWidth();
            this.didMouseJustRelease = true;
            this.mouseActive = false;
        }
        return mouseEvent;
    }

    public MouseEvent mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            this.resetPivot();
        }
        return mouseEvent;
    }

    public MouseEvent mouseClicked(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseEntered(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseExited(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseMoved(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!"camerafun".equals(event.getGroup())) {
            return;
        }
        this.mouseActive = false;
        this.resetPivot();
    }

    @Provides
    CameraFunConfig provideConfig(ConfigManager configManager) {
        this.mouseActive = false;
        this.resetPivot();
        return (CameraFunConfig)configManager.getConfig(CameraFunConfig.class);
    }
}

