/*
 * Decompiled with CFR 0.152.
 */
package com.thatgamerblue.runelite.plugins.rsnhider;

import com.google.inject.Provides;
import com.thatgamerblue.runelite.plugins.rsnhider.RsnHiderConfig;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;

@PluginDescriptor(name="RSN Hider", description="Hides your rsn for streamers.", tags={"twitch"}, enabledByDefault=false)
public class RsnHiderPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private RsnHiderConfig config;
    private String fakeRsn;
    private boolean forceUpdate = false;
    private static final String ALPHA_NUMERIC_STRING = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    @Provides
    private RsnHiderConfig getConfig(ConfigManager configManager) {
        return (RsnHiderConfig)configManager.getConfig(RsnHiderConfig.class);
    }

    public void startUp() {
        this.setFakeRsn();
    }

    public void shutDown() {
        this.clientThread.invokeLater(() -> this.client.runScript(new Object[]{223}));
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("rsnhider")) {
            return;
        }
        this.setFakeRsn();
    }

    @Subscribe
    private void onBeforeRender(BeforeRender event) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.config.hideWidgets()) {
            for (Widget widgetRoot : this.client.getWidgetRoots()) {
                this.processWidget(widgetRoot);
            }
        } else {
            this.updateChatbox();
        }
    }

    private void setFakeRsn() {
        this.forceUpdate = true;
        this.fakeRsn = this.config.customRsn().equals("") ? RsnHiderPlugin.randomAlphaNumeric(12) : this.config.customRsn();
    }

    private void processWidget(Widget widget) {
        if (widget == null) {
            return;
        }
        if (widget.getText() != null) {
            widget.setText(this.replaceRsn(widget.getText()));
        }
        for (Widget child : widget.getStaticChildren()) {
            this.processWidget(child);
        }
        for (Widget dynamicChild : widget.getDynamicChildren()) {
            this.processWidget(dynamicChild);
        }
        for (Widget nestedChild : widget.getNestedChildren()) {
            this.processWidget(nestedChild);
        }
    }

    private void updateChatbox() {
        Widget chatboxTypedText = this.client.getWidget(WidgetInfo.CHATBOX_INPUT);
        if (chatboxTypedText == null || chatboxTypedText.isHidden()) {
            return;
        }
        String[] chatbox = chatboxTypedText.getText().split(":", 2);
        String playerRsn = this.client.getLocalPlayer().getName();
        if (this.forceUpdate || Text.standardize((String)chatbox[0]).contains(Text.standardize((String)playerRsn))) {
            chatbox[0] = this.fakeRsn;
        }
        this.forceUpdate = false;
        chatboxTypedText.setText(chatbox[0] + ":" + (chatbox.length > 1 ? chatbox[1] : ""));
    }

    @Subscribe
    private void onChatMessage(ChatMessage event) {
        if (this.client.getLocalPlayer() == null || this.client.getLocalPlayer().getName() == null) {
            return;
        }
        String replaced = this.replaceRsn(event.getMessage());
        event.setMessage(replaced);
        event.getMessageNode().setValue(replaced);
        if (event.getName() == null) {
            return;
        }
        boolean isLocalPlayer = Text.standardize((String)event.getName()).equalsIgnoreCase(Text.standardize((String)this.client.getLocalPlayer().getName()));
        if (isLocalPlayer) {
            event.setName(this.fakeRsn);
            event.getMessageNode().setName(this.fakeRsn);
        }
    }

    @Subscribe
    private void onOverheadTextChanged(OverheadTextChanged event) {
        event.getActor().setOverheadText(this.replaceRsn(event.getOverheadText()));
    }

    private String replaceRsn(String textIn) {
        String playerRsn = this.client.getLocalPlayer().getName();
        String standardized = Text.standardize((String)playerRsn);
        while (Text.standardize((String)textIn).contains(standardized)) {
            int idx = ((String)textIn).replace("\u00a0", " ").toLowerCase().indexOf(playerRsn.toLowerCase());
            int length = playerRsn.length();
            String partOne = ((String)textIn).substring(0, idx);
            String partTwo = ((String)textIn).substring(idx + length);
            textIn = partOne + this.fakeRsn + partTwo;
        }
        return textIn;
    }

    private static String randomAlphaNumeric(int count) {
        StringBuilder builder = new StringBuilder();
        int i = count;
        while (i-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }
}

