/*
 * Decompiled with CFR 0.152.
 */
package xrio.effectivelevel;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Provides;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Prayer;
import net.runelite.api.Skill;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.apache.commons.lang3.ArrayUtils;
import xrio.effectivelevel.EffectiveLevelConfig;

@PluginDescriptor(name="Effective Levels", description="Shows the invisible effective boosted skill levels in the skills tab.<br>These are the levels that go into the max hit, accuracy roll and <br>defence roll formulas before accounting for equipment bonuses.", tags={"skill", "effective", "boosted", "invisible", "levels"})
public class EffectiveLevelPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private EffectiveLevelConfig config;
    private final Skill[] combatSkills = new Skill[]{Skill.ATTACK, Skill.STRENGTH, Skill.DEFENCE, Skill.RANGED, Skill.MAGIC};
    private final Skill[] nonCombatSkills = new Skill[]{Skill.MINING, Skill.CONSTRUCTION, Skill.FISHING, Skill.WOODCUTTING};
    private final Skill[] skills = (Skill[])ArrayUtils.addAll((Object[])this.combatSkills, (Object[])this.nonCombatSkills);
    private final int[] miningRings = new int[]{25541, 25539, 25545, 25543};

    @Provides
    EffectiveLevelConfig provideConfig(ConfigManager configManager) {
        return (EffectiveLevelConfig)configManager.getConfig(EffectiveLevelConfig.class);
    }

    protected void shutDown() throws Exception {
        this.resetLevels();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("effectivelevel")) {
            this.resetLevels();
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (!GameState.LOGGED_IN.equals((Object)this.client.getGameState())) {
            return;
        }
        for (Skill skill : this.combatSkills) {
            double prayerBoost = this.getPrayerBoost(skill);
            int stanceBonus = this.getStanceBonus(skill);
            double voidBonus = this.getVoidBonus(skill);
            int effectiveLevel = this.client.getBoostedSkillLevel(skill);
            if (this.config.showPrayerBoost()) {
                effectiveLevel = (int)((double)effectiveLevel * prayerBoost);
            }
            if (this.config.showStanceBonus()) {
                effectiveLevel += stanceBonus;
            }
            if (this.config.showAdjustmentConstant()) {
                effectiveLevel += 8;
            }
            if (this.config.showVoidBonus()) {
                effectiveLevel = (int)((double)effectiveLevel * voidBonus);
            }
            this.updateSkillLevel(skill, effectiveLevel);
        }
        if (this.config.showInvisibleBoost()) {
            Set<Integer> inventory;
            int miningLevel = this.client.getBoostedSkillLevel(Skill.MINING);
            int constructionLevel = this.client.getBoostedSkillLevel(Skill.CONSTRUCTION);
            int fishingLevel = this.client.getBoostedSkillLevel(Skill.FISHING);
            int woodcuttingLevel = this.client.getBoostedSkillLevel(Skill.WOODCUTTING);
            Set<Integer> equipment = this.getItemIDs(InventoryID.EQUIPMENT);
            for (int id : this.miningRings) {
                if (!equipment.contains(id)) continue;
                miningLevel += 4;
                break;
            }
            if ((inventory = this.getItemIDs(InventoryID.INVENTORY)).contains(9625)) {
                constructionLevel += 3;
            }
            if (this.client.getLocalPlayer() != null) {
                int regionId = this.client.getLocalPlayer().getWorldLocation().getRegionID();
                if (regionId == 11927 || regionId == 12183) {
                    miningLevel += 7;
                } else if (regionId == 10293) {
                    fishingLevel += 7;
                } else if (regionId == 6198 || regionId == 6454) {
                    woodcuttingLevel += 7;
                }
            }
            this.updateSkillLevel(Skill.MINING, miningLevel);
            this.updateSkillLevel(Skill.CONSTRUCTION, constructionLevel);
            this.updateSkillLevel(Skill.FISHING, fishingLevel);
            this.updateSkillLevel(Skill.WOODCUTTING, woodcuttingLevel);
        }
    }

    private void resetLevels() {
        for (Skill skill : this.skills) {
            this.updateSkillLevel(skill, this.client.getBoostedSkillLevel(skill));
        }
    }

    private void updateSkillLevel(Skill skill, int effectiveLevel) {
        int childId;
        switch (skill) {
            case ATTACK: {
                childId = 1;
                break;
            }
            case STRENGTH: {
                childId = 2;
                break;
            }
            case DEFENCE: {
                childId = 3;
                break;
            }
            case RANGED: {
                childId = 4;
                break;
            }
            case MAGIC: {
                childId = 6;
                break;
            }
            case MINING: {
                childId = 17;
                break;
            }
            case CONSTRUCTION: {
                childId = 8;
                break;
            }
            case FISHING: {
                childId = 19;
                break;
            }
            case WOODCUTTING: {
                childId = 22;
                break;
            }
            default: {
                return;
            }
        }
        Widget skillWidget = this.client.getWidget(320, childId);
        if (skillWidget == null) {
            return;
        }
        Widget[] skillWidgetComponents = skillWidget.getDynamicChildren();
        if (skillWidgetComponents.length >= 4) {
            skillWidgetComponents[3].setText("" + effectiveLevel);
        }
    }

    private double getPrayerBoost(Skill skill) {
        double multiplier = 1.0;
        switch (skill) {
            case ATTACK: {
                multiplier = this.client.isPrayerActive(Prayer.CLARITY_OF_THOUGHT) ? 1.05 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.IMPROVED_REFLEXES) ? 1.1 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.INCREDIBLE_REFLEXES) ? 1.15 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.CHIVALRY) ? 1.15 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.PIETY) ? 1.2 : multiplier;
                break;
            }
            case STRENGTH: {
                multiplier = this.client.isPrayerActive(Prayer.BURST_OF_STRENGTH) ? 1.05 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.SUPERHUMAN_STRENGTH) ? 1.1 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.ULTIMATE_STRENGTH) ? 1.15 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.CHIVALRY) ? 1.18 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.PIETY) ? 1.23 : multiplier;
                break;
            }
            case DEFENCE: {
                multiplier = this.client.isPrayerActive(Prayer.THICK_SKIN) ? 1.05 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.ROCK_SKIN) ? 1.1 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.STEEL_SKIN) ? 1.15 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.CHIVALRY) ? 1.2 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.PIETY) ? 1.25 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.RIGOUR) ? 1.25 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.AUGURY) ? 1.25 : multiplier;
                break;
            }
            case RANGED: {
                multiplier = this.client.isPrayerActive(Prayer.SHARP_EYE) ? 1.05 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.HAWK_EYE) ? 1.1 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.EAGLE_EYE) ? 1.15 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.RIGOUR) ? 1.2 : multiplier;
                break;
            }
            case MAGIC: {
                multiplier = this.client.isPrayerActive(Prayer.MYSTIC_WILL) ? 1.05 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.MYSTIC_LORE) ? 1.1 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.MYSTIC_MIGHT) ? 1.15 : multiplier;
                multiplier = this.client.isPrayerActive(Prayer.AUGURY) ? 1.25 : multiplier;
            }
        }
        return multiplier;
    }

    private int getStanceBonus(Skill skill) {
        int attackStyleVarbit = this.client.getVarpValue(43);
        int combatStyleVarbit = this.client.getVarbitValue(357);
        String attackStyle = CombatStyle.getAttackStyleText(combatStyleVarbit, attackStyleVarbit);
        int bonus = 0;
        switch (skill) {
            case ATTACK: {
                bonus = "Accurate".equals(attackStyle) ? 3 : bonus;
                bonus = "Controlled".equals(attackStyle) ? 1 : bonus;
                break;
            }
            case STRENGTH: {
                bonus = "Aggressive".equals(attackStyle) ? 3 : bonus;
                bonus = "Controlled".equals(attackStyle) ? 1 : bonus;
                break;
            }
            case DEFENCE: {
                bonus = "Controlled".equals(attackStyle) ? 1 : bonus;
                bonus = "Defensive".equals(attackStyle) ? 3 : bonus;
                bonus = "Longrange".equals(attackStyle) ? 3 : bonus;
                break;
            }
            case RANGED: {
                bonus = "Accurate ranging".equals(attackStyle) ? 3 : bonus;
                break;
            }
            case MAGIC: {
                bonus = "Accurate casting".equals(attackStyle) ? 3 : bonus;
                bonus = "Longrange casting".equals(attackStyle) ? 1 : bonus;
            }
        }
        return bonus;
    }

    private Set<Integer> getItemIDs(InventoryID inventoryID) {
        ItemContainer container = this.client.getItemContainer(inventoryID);
        HashSet<Integer> itemIDs = new HashSet<Integer>();
        if (container != null) {
            for (Item item : container.getItems()) {
                itemIDs.add(item.getId());
            }
        }
        return itemIDs;
    }

    private double getVoidBonus(Skill skill) {
        boolean voidHelmMagic;
        double multiplier = 1.0;
        if (Skill.DEFENCE.equals((Object)skill)) {
            return multiplier;
        }
        Set<Integer> itemIDs = this.getItemIDs(InventoryID.EQUIPMENT);
        boolean voidGloves = itemIDs.contains(8842) || itemIDs.contains(24182) || itemIDs.contains(26467) || itemIDs.contains(27002);
        boolean voidTop = itemIDs.contains(8839) || itemIDs.contains(24177) || itemIDs.contains(26463) || itemIDs.contains(27000);
        boolean voidBottom = itemIDs.contains(8840) || itemIDs.contains(24179) || itemIDs.contains(26465) || itemIDs.contains(27001);
        boolean eliteVoidTop = itemIDs.contains(13072) || itemIDs.contains(24178) || itemIDs.contains(26469) || itemIDs.contains(27003);
        boolean eliteVoidBottom = itemIDs.contains(13073) || itemIDs.contains(24180) || itemIDs.contains(26471) || itemIDs.contains(27004);
        boolean voidHelmMelee = itemIDs.contains(11665) || itemIDs.contains(24185) || itemIDs.contains(26477) || itemIDs.contains(27007);
        boolean voidHelmRanged = itemIDs.contains(11664) || itemIDs.contains(24184) || itemIDs.contains(26475) || itemIDs.contains(27006);
        boolean bl = voidHelmMagic = itemIDs.contains(11663) || itemIDs.contains(24183) || itemIDs.contains(26473) || itemIDs.contains(27005);
        if (!voidGloves || !voidTop && !eliteVoidTop || !voidBottom && !eliteVoidBottom) {
            return multiplier;
        }
        if ((Skill.ATTACK.equals((Object)skill) || Skill.STRENGTH.equals((Object)skill)) && voidHelmMelee) {
            multiplier = 1.1;
        } else if (Skill.RANGED.equals((Object)skill) && voidHelmRanged) {
            multiplier = eliteVoidTop && eliteVoidBottom ? 1.125 : 1.1;
        } else if (Skill.MAGIC.equals((Object)skill) && voidHelmMagic) {
            multiplier = eliteVoidTop && eliteVoidBottom ? 1.475 : 1.45;
        }
        return multiplier;
    }

    private static enum CombatStyle {
        TYPE_0("Accurate", "Aggressive", null, "Defensive"),
        TYPE_1("Accurate", "Aggressive", "Aggressive", "Defensive"),
        TYPE_2("Accurate", "Aggressive", null, "Defensive"),
        TYPE_3("Accurate ranging", "Rapid", null, "Longrange"),
        TYPE_4("Accurate", "Aggressive", "Controlled", "Defensive"),
        TYPE_5("Accurate ranging", "Rapid", null, "Longrange"),
        TYPE_6("Aggressive", "Rapid", "Casting", null),
        TYPE_7("Accurate ranging", "Rapid", null, "Longrange"),
        TYPE_8("Other", "Aggressive", null, null),
        TYPE_9("Accurate", "Aggressive", "Controlled", "Defensive"),
        TYPE_10("Accurate", "Aggressive", "Aggressive", "Defensive"),
        TYPE_11("Accurate", "Aggressive", "Aggressive", "Defensive"),
        TYPE_12("Controlled", "Aggressive", null, "Defensive"),
        TYPE_13("Accurate", "Aggressive", null, "Defensive"),
        TYPE_14("Accurate", "Aggressive", "Aggressive", "Defensive"),
        TYPE_15("Controlled", "Controlled", "Controlled", "Defensive"),
        TYPE_16("Accurate", "Aggressive", "Controlled", "Defensive"),
        TYPE_17("Accurate", "Aggressive", "Aggressive", "Defensive"),
        TYPE_18("Accurate", "Aggressive", null, "Defensive", "Casting", "Defensive casting"),
        TYPE_19("Accurate ranging", "Rapid", null, "Longrange"),
        TYPE_20("Accurate", "Controlled", null, "Defensive"),
        TYPE_21("Accurate", "Aggressive", null, "Defensive", "Casting", "Defensive casting"),
        TYPE_22("Accurate", "Aggressive", "Aggressive", "Defensive"),
        TYPE_23("Accurate casting", "Accurate casting", null, "Longrange casting"),
        TYPE_24("Accurate", "Aggressive", "Controlled", "Defensive"),
        TYPE_25("Controlled", "Aggressive", null, "Defensive"),
        TYPE_26("Aggressive", "Aggressive", null, "Aggressive"),
        TYPE_27("Accurate", null, null, "Other"),
        TYPE_28("Accurate casting", "Accurate casting", null, "Longrange casting"),
        TYPE_29("Accurate", "Aggressive", "Aggressive", "Defensive");

        private final String[] attackStyles;
        private static final Map<Integer, CombatStyle> combatStyles;

        private CombatStyle(String ... attackStyles) {
            this.attackStyles = attackStyles;
        }

        public static String getAttackStyleText(int combatStyleId, int attackStyleId) {
            return CombatStyle.combatStyles.get((Object)Integer.valueOf((int)combatStyleId)).attackStyles[attackStyleId];
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (CombatStyle combatStyle : CombatStyle.values()) {
                builder.put((Object)combatStyle.ordinal(), (Object)combatStyle);
            }
            combatStyles = builder.build();
        }
    }
}

