/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.coffincounter;

import io.hydrox.coffincounter.CoffinCounterConfig;
import io.hydrox.coffincounter.CoffinCounterPlugin;
import io.hydrox.coffincounter.Shade;
import java.awt.Color;
import java.awt.image.BufferedImage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;

public class ShadeRemainsInfobox
extends InfoBox {
    private final Shade shade;
    private final CoffinCounterPlugin plugin;
    private final CoffinCounterConfig config;

    public ShadeRemainsInfobox(BufferedImage image, Shade shade, CoffinCounterPlugin plugin, CoffinCounterConfig config) {
        super(image, (Plugin)plugin);
        this.shade = shade;
        this.plugin = plugin;
        this.config = config;
        this.setTooltip(shade.getName() + " remains in your Coffin");
    }

    public String getText() {
        int count = this.plugin.getStored().get((Object)this.shade);
        return Integer.toString(count);
    }

    public Color getTextColor() {
        return Color.WHITE;
    }

    public boolean render() {
        int threshold = this.config.infoboxZero() ? -1 : 0;
        return this.plugin.getStored().get((Object)this.shade) > threshold;
    }
}

