/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.coffincounter;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.text.WordUtils;

public enum Shade {
    LOAR(3396, new Color(3, 214, 3)),
    PHRIN(3398, new Color(0, 0, 0), Color.WHITE),
    RIYL(3400, new Color(189, 3, 1)),
    ASYN(3402, new Color(0, 114, 255)),
    FIYR(3404, new Color(144, 132, 132)),
    URIUM(25419, new Color(248, 176, 8));

    private final String name = WordUtils.capitalize((String)this.name().toLowerCase());
    private final int remainsID;
    private final Color colour;
    private final Color outline;
    private static final Map<String, Shade> NAME_MAP;
    private static final Map<Integer, Shade> REMAINS_MAP;

    private Shade(int remainsID, Color colour) {
        this(remainsID, colour, Color.BLACK);
    }

    private Shade(int remainsID, Color colour, Color shadow) {
        this.remainsID = remainsID;
        this.colour = colour;
        this.outline = shadow;
    }

    static Shade fromName(String name) {
        return NAME_MAP.get(name);
    }

    static Shade fromRemainsID(int id) {
        return REMAINS_MAP.get(id);
    }

    static Set<Integer> REMAINS() {
        return REMAINS_MAP.keySet();
    }

    public String getName() {
        return this.name;
    }

    public int getRemainsID() {
        return this.remainsID;
    }

    public Color getColour() {
        return this.colour;
    }

    public Color getOutline() {
        return this.outline;
    }

    static {
        NAME_MAP = new HashMap<String, Shade>();
        REMAINS_MAP = new HashMap<Integer, Shade>();
        for (Shade s : Shade.values()) {
            NAME_MAP.put(s.getName(), s);
            REMAINS_MAP.put(s.getRemainsID(), s);
        }
    }
}

