/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.coffincounter;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.inject.Provides;
import io.hydrox.coffincounter.Coffin;
import io.hydrox.coffincounter.CoffinContentsInfobox;
import io.hydrox.coffincounter.CoffinCounterConfig;
import io.hydrox.coffincounter.CoffinCounterOverlay;
import io.hydrox.coffincounter.Shade;
import io.hydrox.coffincounter.ShadeRemainsInfobox;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Coffin Counter", description="Track what remains your coffin contains.", tags={"shades", "remains", "coffin", "count", "loar", "phrin", "riyl", "asyn", "fiyr", "urium", "morton", "mort'ton", "sacred"})
public class CoffinCounterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CoffinCounterPlugin.class);
    private static final String CHECK_START = "Loar ";
    private static final Pattern CHECK_PATTERN = Pattern.compile("Loar (\\d{1,2}) / Phrin (\\d{1,2}) / Riyl (\\d{1,2}) / Asyn (\\d{1,2}) / Fiyr (\\d{1,2}) / Urium (\\d{1,2})");
    private static final String PICK_UP_START = "You put ";
    private static final Pattern PICK_UP_PATTERN = Pattern.compile("You put the (\\w+) remains into your open coffin\\.");
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private CoffinCounterOverlay overlay;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private CoffinCounterConfig config;
    private final Map<Shade, Integer> stored = Arrays.stream(Shade.values()).collect(LinkedHashMap::new, (map, shade) -> map.put(shade, -1), Map::putAll);
    private Multiset<Integer> inventorySnapshot;
    private boolean checkFill;
    private boolean usingRemains;
    private boolean usingCoffin;

    @Provides
    CoffinCounterConfig getConfig(ConfigManager configManager) {
        return (CoffinCounterConfig)configManager.getConfig(CoffinCounterConfig.class);
    }

    public void startUp() {
        this.loadCoffinState();
        this.overlayManager.add((Overlay)this.overlay);
    }

    public void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if ("coffincounter".equals(event.getGroup()) && !"stored".equals(event.getKey())) {
            this.clientThread.invoke(this::updateInfoboxes);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGING_IN) {
            this.loadCoffinState();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String message = Text.removeTags((String)event.getMessage());
        if (message.startsWith(CHECK_START)) {
            Matcher m = CHECK_PATTERN.matcher(message);
            if (!m.matches()) {
                return;
            }
            for (Shade s : Shade.values()) {
                this.store(s, Integer.parseInt(m.group(s.ordinal() + 1)));
            }
            this.updateInfoboxes();
            this.saveCoffinState();
        } else if (message.startsWith(PICK_UP_START)) {
            Matcher m = PICK_UP_PATTERN.matcher(message);
            if (!m.matches()) {
                return;
            }
            Shade shade = Shade.fromName(m.group(1));
            if (shade == null) {
                return;
            }
            this.store(shade, this.stored.get((Object)shade) + 1);
            this.updateInfoboxes();
            this.saveCoffinState();
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getWidget() == null) {
            return;
        }
        int itemId = event.getWidget().getItemId();
        if (this.usingRemains || this.usingCoffin) {
            if (event.getMenuAction() == MenuAction.WIDGET_TARGET_ON_WIDGET && (this.usingRemains && Coffin.getFromItem(itemId) != null || this.usingCoffin && Shade.fromRemainsID(itemId) != null)) {
                this.inventorySnapshot = this.createInventorySnapshot();
                this.checkFill = true;
            }
            this.usingRemains = false;
            this.usingCoffin = false;
        } else if (event.getMenuOption().equals("Fill") && event.getMenuAction() == MenuAction.CC_OP && event.getId() == 2 && (Coffin.getFromItem(itemId) != null || WidgetInfo.TO_GROUP((int)event.getWidget().getId()) == 387)) {
            this.inventorySnapshot = this.createInventorySnapshot();
            this.checkFill = true;
        } else if (event.getMenuAction() == MenuAction.WIDGET_TARGET && itemId != -1) {
            if (Shade.fromRemainsID(itemId) != null) {
                this.usingRemains = true;
            } else if (Coffin.getFromItem(itemId) != null) {
                this.usingCoffin = true;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.checkFill) {
            return;
        }
        Widget chatDialogueSprite = this.client.getWidget(WidgetInfo.DIALOG_SPRITE_SPRITE);
        if (chatDialogueSprite != null && Coffin.getFromItem(chatDialogueSprite.getItemId()) != null) {
            this.checkFill = false;
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() != InventoryID.INVENTORY.getId()) {
            return;
        }
        Multiset<Integer> current = this.createInventorySnapshot();
        if (current != null && current.contains((Object)25457)) {
            this.stored.replaceAll((s, v) -> -1);
            this.updateInfoboxes();
            this.saveCoffinState();
            return;
        }
        if (!this.checkFill || this.inventorySnapshot == null) {
            return;
        }
        this.checkFill = false;
        Multiset delta = Multisets.difference(this.inventorySnapshot, current);
        delta.forEachEntry((id, change) -> {
            Shade shade = Shade.fromRemainsID(id);
            this.store(shade, this.stored.get((Object)shade) + change);
        });
        this.updateInfoboxes();
        this.saveCoffinState();
    }

    private Multiset<Integer> createInventorySnapshot() {
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer != null) {
            HashMultiset snapshot = HashMultiset.create();
            Arrays.stream(itemContainer.getItems()).filter(item -> Shade.REMAINS().contains(item.getId())).forEach(arg_0 -> CoffinCounterPlugin.lambda$createInventorySnapshot$4((Multiset)snapshot, arg_0));
            return snapshot;
        }
        return null;
    }

    private void saveCoffinState() {
        this.configManager.setRSProfileConfiguration("coffincounter", "stored", (Object)Text.toCSV((Collection)this.stored.values().stream().map(Object::toString).collect(Collectors.toList())));
    }

    private void loadCoffinState() {
        String state = this.configManager.getRSProfileConfiguration("coffincounter", "stored");
        if (state == null) {
            return;
        }
        List states = Text.fromCSV((String)state);
        for (int i = 0; i < Shade.values().length; ++i) {
            this.store(Shade.values()[i], Integer.parseInt((String)states.get(i)));
        }
        this.updateInfoboxes();
    }

    private void store(Shade shade, int value) {
        this.stored.put(shade, value);
    }

    private void updateInfoboxes() {
        this.infoBoxManager.removeIf(i -> i instanceof ShadeRemainsInfobox || i instanceof CoffinContentsInfobox);
        if (this.config.infoboxStyle() == CoffinCounterConfig.InfoboxStyle.SPLIT) {
            for (Shade s : Shade.values()) {
                this.infoBoxManager.addInfoBox((InfoBox)new ShadeRemainsInfobox((BufferedImage)this.itemManager.getImage(s.getRemainsID()), s, this, this.config));
            }
        } else if (this.config.infoboxStyle() == CoffinCounterConfig.InfoboxStyle.COMBINED) {
            this.infoBoxManager.addInfoBox((InfoBox)new CoffinContentsInfobox((BufferedImage)this.itemManager.getImage(25467), this, this.config));
        }
    }

    public Map<Shade, Integer> getStored() {
        return this.stored;
    }

    private static /* synthetic */ void lambda$createInventorySnapshot$4(Multiset snapshot, Item item) {
        snapshot.add((Object)item.getId(), item.getQuantity());
    }
}

