/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.coffincounter;

import com.google.inject.Inject;
import io.hydrox.coffincounter.Coffin;
import io.hydrox.coffincounter.CoffinCounterPlugin;
import io.hydrox.coffincounter.Shade;
import io.hydrox.coffincounter.UIUtil;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Map;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;

public class CoffinCounterOverlay
extends WidgetItemOverlay {
    private final CoffinCounterPlugin plugin;

    @Inject
    CoffinCounterOverlay(CoffinCounterPlugin plugin) {
        this.plugin = plugin;
        this.showOnInventory();
        this.showOnBank();
        this.showOnEquipment();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        if (!Coffin.ALL_COFFINS().contains(itemId)) {
            return;
        }
        graphics.setFont(FontManager.getRunescapeSmallFont());
        int idx = 0;
        for (Map.Entry<Shade, Integer> entry : this.plugin.getStored().entrySet()) {
            if (entry.getValue() == 0) continue;
            Shade shade = entry.getKey();
            Integer value = entry.getValue();
            Rectangle bounds = widgetItem.getCanvasBounds();
            int drawX = bounds.x + 20 * (idx / 3);
            int drawY = bounds.y + 10 + 12 * (idx % 3);
            if (entry.getValue() == -1) {
                UIUtil.drawString(graphics, shade, "?", drawX, drawY);
            } else {
                UIUtil.drawString(graphics, shade, value.toString(), drawX, drawY);
            }
            ++idx;
        }
    }
}

