/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.coffincounter;

import io.hydrox.coffincounter.CoffinCounterConfig;
import io.hydrox.coffincounter.CoffinCounterPlugin;
import io.hydrox.coffincounter.Shade;
import io.hydrox.coffincounter.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Map;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;

public class CoffinContentsInfobox
extends InfoBox {
    private final CoffinCounterPlugin plugin;
    private final CoffinCounterConfig config;

    public CoffinContentsInfobox(BufferedImage baseCoffin, CoffinCounterPlugin plugin, CoffinCounterConfig config) {
        super(CoffinContentsInfobox.createImage(baseCoffin, plugin, config), (Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
        this.setTooltip("Coffin contents");
    }

    public String getText() {
        return "";
    }

    public Color getTextColor() {
        return Color.WHITE;
    }

    public boolean render() {
        int threshold = this.config.infoboxZero() ? -1 : 0;
        return this.plugin.getStored().values().stream().anyMatch(v -> v > threshold);
    }

    private static BufferedImage createImage(BufferedImage baseCoffin, CoffinCounterPlugin plugin, CoffinCounterConfig config) {
        BufferedImage coffin = new BufferedImage(baseCoffin.getColorModel(), baseCoffin.copyData(null), baseCoffin.getColorModel().isAlphaPremultiplied(), null);
        Graphics graphics = coffin.getGraphics();
        graphics.setFont(FontManager.getRunescapeSmallFont());
        int idx = 0;
        for (Map.Entry<Shade, Integer> entry : plugin.getStored().entrySet()) {
            Integer value = entry.getValue();
            if (!config.infoboxZero() && value == 0) continue;
            Shade shade = entry.getKey();
            int drawX = 20 * (idx / 3);
            int drawY = 10 + 12 * (idx % 3);
            if (entry.getValue() == -1) {
                UIUtil.drawString(graphics, shade, "?", drawX, drawY);
            } else {
                UIUtil.drawString(graphics, shade, value.toString(), drawX, drawY);
            }
            ++idx;
        }
        return coffin;
    }
}

