/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.coffincounter;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum Coffin {
    BRONZE(3, 25459, 25469),
    STEEL(8, 25461, 25470),
    BLACK(14, 25463, 25471),
    SILVER(20, 25465, 25472),
    GOLD(28, 25467, 25473);

    private final int maxRemains;
    private final int[] itemIDs;
    private static final Map<Integer, Coffin> MAP;

    private Coffin(int maxRemains, int ... itemIDs) {
        this.maxRemains = maxRemains;
        this.itemIDs = itemIDs;
    }

    static Set<Integer> ALL_COFFINS() {
        return MAP.keySet();
    }

    static Coffin getFromItem(int itemID) {
        return MAP.get(itemID);
    }

    public int getMaxRemains() {
        return this.maxRemains;
    }

    public int[] getItemIDs() {
        return this.itemIDs;
    }

    static {
        MAP = new HashMap<Integer, Coffin>();
        for (Coffin c : Coffin.values()) {
            for (int id : c.itemIDs) {
                MAP.put(id, c);
            }
        }
    }
}

