/*
 * Decompiled with CFR 0.152.
 */
package io.cbitler.stealingartefacts;

import com.google.inject.Provides;
import io.cbitler.stealingartefacts.StealingArtefactsConfig;
import io.cbitler.stealingartefacts.StealingArtefactsHouseOverlay;
import io.cbitler.stealingartefacts.StealingArtefactsOverlay;
import io.cbitler.stealingartefacts.StealingArtefactsPatrolOverlay;
import io.cbitler.stealingartefacts.StealingArtefactsState;
import io.cbitler.stealingartefacts.StealingArtefactsUtil;
import java.util.HashSet;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.UsernameChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.xptracker.XpTrackerPlugin;
import net.runelite.client.plugins.xptracker.XpTrackerService;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Stealing Artefacts", description="Show the current house for stealing artefacts", tags={})
@PluginDependency(value=XpTrackerPlugin.class)
public class StealingArtefactsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(StealingArtefactsPlugin.class);
    @Inject
    private OverlayManager overlayManager;
    @Inject
    ConfigManager configManager;
    @Inject
    private StealingArtefactsOverlay overlay;
    @Inject
    private StealingArtefactsHouseOverlay houseOverlay;
    @Inject
    private StealingArtefactsPatrolOverlay patrolOverlay;
    @Inject
    private Client client;
    @Inject
    private XpTrackerService xpTrackerService;
    public HashSet<GameObject> markedObjects = new HashSet();
    public HashSet<NPC> markedNPCs = new HashSet();
    public StealingArtefactsState currentState;
    public boolean highlightPatrols = true;
    public boolean showArtefactsToNextLevel = true;
    public static final WorldPoint EAST_GUARD_POS = new WorldPoint(1777, 3746, 0);
    public static final WorldPoint SOUTHEAST_GUARD_POS = new WorldPoint(1780, 3731, 0);
    public boolean eastGuardLured = false;
    public boolean southEastGuardLured = false;
    public NPC captainKhaled;
    public int artefactsToGoal = -1;

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.houseOverlay);
        this.overlayManager.add((Overlay)this.patrolOverlay);
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.loadConfig();
        }
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.houseOverlay);
        this.overlayManager.remove((Overlay)this.patrolOverlay);
        if (this.client.getLocalPlayer() != null && this.isInPisc(this.client.getLocalPlayer().getWorldLocation())) {
            this.client.clearHintArrow();
        }
    }

    @Provides
    StealingArtefactsConfig providesConfig(ConfigManager configManager) {
        return (StealingArtefactsConfig)configManager.getConfig(StealingArtefactsConfig.class);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged e) {
        if (e.getGameState() == GameState.LOGGING_IN || e.getGameState() == GameState.LOGIN_SCREEN || e.getGameState() == GameState.HOPPING) {
            this.markedNPCs.clear();
            this.markedObjects.clear();
        }
        if (e.getGameState() == GameState.LOGGED_IN && !this.isInPisc(this.client.getLocalPlayer().getWorldLocation())) {
            this.markedNPCs.clear();
            this.markedObjects.clear();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged c) {
        if (!c.getGroup().equalsIgnoreCase("StealingArtefacts")) {
            return;
        }
        this.handleRefreshCurrentHouse();
    }

    @Subscribe
    public void onUsernameChanged(UsernameChanged e) {
        if (this.client.getGameState() == GameState.LOGIN_SCREEN || this.client.getGameState() == GameState.LOGGED_IN) {
            this.loadConfig();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getLocalPlayer() != null && this.isInPisc(this.client.getLocalPlayer().getWorldLocation())) {
            if (this.currentState != null && this.client.getLocalPlayer() != null) {
                WorldPoint playerPos;
                if (this.currentState == StealingArtefactsState.FAILURE || this.currentState == StealingArtefactsState.DELIVER_ARTEFACT) {
                    if (this.captainKhaled != null) {
                        this.client.setHintArrow(this.captainKhaled);
                    }
                } else if (this.currentState != StealingArtefactsState.NO_TASK && (playerPos = this.client.getLocalPlayer().getWorldLocation()).distanceTo(this.currentState.getHintLocation()) > 3) {
                    this.client.setHintArrow(this.currentState.getHintLocation());
                }
            }
        } else if (this.client.getHintArrowPoint() != null && this.isInPisc(this.client.getHintArrowPoint())) {
            this.client.clearHintArrow();
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        if (this.shouldMarkObject(event.getGameObject())) {
            this.markedObjects.add(event.getGameObject());
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        if (event.getGameObject() != null && !this.markedObjects.isEmpty()) {
            this.markedObjects.remove(event.getGameObject());
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (event.getNpc().getId() == 6972) {
            this.captainKhaled = event.getNpc();
        }
        if (event.getNpc().getId() >= 6973 && event.getNpc().getId() <= 6980) {
            this.markedNPCs.add(event.getNpc());
            log.debug("NPC Spawned: {} Index: {}", (Object)event.getNpc().getName(), (Object)event.getNpc().getId());
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        if (event.getNpc() == this.captainKhaled) {
            this.captainKhaled = null;
            if (this.currentState == StealingArtefactsState.DELIVER_ARTEFACT || this.currentState == StealingArtefactsState.FAILURE) {
                this.client.clearHintArrow();
            }
        }
        log.debug("NPC Spawned: {} Index: {}", (Object)event.getNpc().getName(), (Object)event.getNpc().getId());
        this.markedNPCs.remove(event.getNpc());
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        StealingArtefactsState state = StealingArtefactsState.values()[this.client.getVarbitValue(4903)];
        if (state != null) {
            this.updateState(state);
        }
        if (state == StealingArtefactsState.DELIVER_ARTEFACT || state == StealingArtefactsState.FAILURE) {
            if (this.captainKhaled != null) {
                this.client.setHintArrow(this.captainKhaled);
            } else if (this.client.getLocalPlayer() != null && this.isInPisc(this.client.getLocalPlayer().getWorldLocation())) {
                this.client.clearHintArrow();
            }
            this.markedObjects.clear();
        } else if (state == StealingArtefactsState.NO_TASK) {
            if (this.client.getLocalPlayer() != null && this.isInPisc(this.client.getLocalPlayer().getWorldLocation())) {
                this.client.clearHintArrow();
            }
            this.markedObjects.clear();
        } else if (this.client.getLocalPlayer() != null && this.isInPisc(this.client.getLocalPlayer().getWorldLocation())) {
            this.client.setHintArrow(state.getHintLocation());
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged e) {
        if (this.client.getLocalPlayer() != null && this.isInPisc(this.client.getLocalPlayer().getWorldLocation())) {
            this.artefactsToGoal = StealingArtefactsUtil.artefactsToNextLevel(this.client, this.xpTrackerService);
            log.debug("Artefacts to goal: {}", (Object)this.artefactsToGoal);
        }
    }

    private void handleRefreshCurrentHouse() {
        String stateGroup = "StealingArtefacts." + this.client.getUsername();
        String configStateText = this.configManager.getConfiguration(stateGroup, "currentState");
        if (configStateText != null) {
            int configState = Integer.parseInt(configStateText);
            if (configState != -1) {
                this.currentState = StealingArtefactsState.values()[configState];
            }
            if (this.client.getLocalPlayer() != null && this.isInPisc(this.client.getLocalPlayer().getWorldLocation())) {
                this.client.clearHintArrow();
                if (this.currentState == StealingArtefactsState.DELIVER_ARTEFACT || this.currentState == StealingArtefactsState.FAILURE) {
                    if (this.captainKhaled != null) {
                        this.client.setHintArrow(this.captainKhaled);
                    }
                    this.markedObjects.clear();
                } else if (this.currentState != StealingArtefactsState.NO_TASK) {
                    this.client.setHintArrow(this.currentState.getHintLocation());
                }
            }
        }
    }

    public void loadConfig() {
        this.handleRefreshCurrentHouse();
    }

    public boolean shouldMarkObject(GameObject object) {
        boolean shouldMark = false;
        if (this.currentState != null && this.currentState.getDrawerId() != -1) {
            boolean bl = shouldMark = object.getId() == this.currentState.getDrawerId();
        }
        if (this.currentState != null && this.currentState.getLadderId() != -1 && object.getWorldLocation().distanceTo(this.currentState.getLadderLocation()) == 0) {
            shouldMark = object.getId() == this.currentState.getLadderId();
        }
        return shouldMark;
    }

    private void updateState(StealingArtefactsState state) {
        String stateGroup = "StealingArtefacts." + this.client.getUsername();
        if (state == this.currentState) {
            return;
        }
        if (state == null) {
            this.currentState = null;
            this.configManager.unsetConfiguration(stateGroup, "currentState");
        } else {
            this.currentState = state;
            this.configManager.setConfiguration(stateGroup, "currentState", (Object)state.ordinal());
        }
    }

    public boolean isInPisc(WorldPoint position) {
        if (position.getX() >= 1739 && position.getX() <= 1860) {
            return position.getY() >= 3675 && position.getY() <= 3803;
        }
        return false;
    }

    public boolean isGuardLured(NPC guard) {
        boolean isLured = false;
        int eastGuardDistance = guard.getWorldLocation().distanceTo(EAST_GUARD_POS);
        int southEastGuardDistance = guard.getWorldLocation().distanceTo(SOUTHEAST_GUARD_POS);
        if (eastGuardDistance == 0 && guard.getCurrentOrientation() == 0) {
            isLured = true;
            this.eastGuardLured = true;
        } else if (eastGuardDistance == 0) {
            this.eastGuardLured = false;
        }
        if (southEastGuardDistance == 0 && guard.getCurrentOrientation() == 512) {
            isLured = true;
            this.southEastGuardLured = true;
        } else if (southEastGuardDistance == 0) {
            this.southEastGuardLured = false;
        }
        return isLured;
    }
}

