/*
 * Decompiled with CFR 0.152.
 */
package io.cbitler.stealingartefacts;

import io.cbitler.stealingartefacts.StealingArtefactsConfig;
import io.cbitler.stealingartefacts.StealingArtefactsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class StealingArtefactsPatrolOverlay
extends Overlay {
    public static final Color CLICKBOX_BORDER = Color.YELLOW;
    public static final Color CLICKBOX_FILL_COLOR = new Color(255, 0, 0, 50);
    public static final Color CLICKBOX_FILL_COLOR_LURED = new Color(0, 255, 0, 50);
    private final StealingArtefactsPlugin plugin;
    private final StealingArtefactsConfig config;
    private final Client client;

    @Inject
    StealingArtefactsPatrolOverlay(Client client, StealingArtefactsPlugin plugin, StealingArtefactsConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        Point mousePosition = this.client.getMouseCanvasPosition();
        if (this.config.highlightPatrols()) {
            for (NPC actor : this.plugin.markedNPCs) {
                if (actor.getId() == 6980 && this.plugin.isGuardLured(actor) && this.config.highlightGuardLures()) {
                    OverlayUtil.renderHoverableArea((Graphics2D)graphics, (Shape)actor.getConvexHull(), (Point)mousePosition, (Color)CLICKBOX_FILL_COLOR_LURED, (Color)CLICKBOX_BORDER, (Color)CLICKBOX_BORDER);
                    continue;
                }
                OverlayUtil.renderHoverableArea((Graphics2D)graphics, (Shape)actor.getConvexHull(), (Point)mousePosition, (Color)CLICKBOX_FILL_COLOR, (Color)CLICKBOX_BORDER, (Color)CLICKBOX_BORDER);
            }
        }
        return null;
    }
}

