/*
 * Decompiled with CFR 0.152.
 */
package io.cbitler.stealingartefacts;

import io.cbitler.stealingartefacts.StealingArtefactsConfig;
import io.cbitler.stealingartefacts.StealingArtefactsPlugin;
import io.cbitler.stealingartefacts.StealingArtefactsState;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class StealingArtefactsOverlay
extends Overlay {
    private final StealingArtefactsPlugin plugin;
    private final Client client;
    private final StealingArtefactsConfig config;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    private StealingArtefactsOverlay(Client client, StealingArtefactsPlugin plugin, StealingArtefactsConfig config) {
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.client.getLocalPlayer() != null && this.plugin.isInPisc(this.client.getLocalPlayer().getWorldLocation())) {
            this.panelComponent.getChildren().clear();
            String title = "Stealing Artefacts";
            String targetLine = this.getTargetMessage(this.plugin.currentState);
            this.panelComponent.getChildren().add(TitleComponent.builder().text(title).color(Color.YELLOW).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Current Target:").build());
            this.panelComponent.getChildren().add(LineComponent.builder().left(targetLine).build());
            if (this.plugin.artefactsToGoal > 0 && this.config.showToNextLevel()) {
                this.panelComponent.getChildren().add(LineComponent.builder().build());
                this.panelComponent.getChildren().add(LineComponent.builder().left("Artefacts until goal:").build());
                this.panelComponent.getChildren().add(LineComponent.builder().left(String.valueOf(this.plugin.artefactsToGoal)).build());
            }
            if (this.config.highlightGuardLures()) {
                this.panelComponent.getChildren().add(LineComponent.builder().build());
                this.panelComponent.getChildren().add(LineComponent.builder().left("Guard Lures:").build());
                String eastGuardLured = this.plugin.eastGuardLured ? "\u2713" : "\u2717";
                this.panelComponent.getChildren().add(LineComponent.builder().left("Eastern Guard").right(eastGuardLured).rightFont(FontManager.getDefaultFont()).rightColor(this.plugin.eastGuardLured ? Color.GREEN : Color.RED).build());
                String southEastGuardLured = this.plugin.southEastGuardLured ? "\u2713" : "\u2717";
                this.panelComponent.getChildren().add(LineComponent.builder().left("South-East Guard").right(southEastGuardLured).rightFont(FontManager.getDefaultFont()).rightColor(this.plugin.southEastGuardLured ? Color.GREEN : Color.RED).build());
            }
            this.panelComponent.setPreferredSize(new Dimension(200, 0));
            return this.panelComponent.render(graphics);
        }
        return null;
    }

    private String getTargetMessage(StealingArtefactsState state) {
        if (state == null || state == StealingArtefactsState.NO_TASK) {
            return "None";
        }
        return state.getTarget();
    }
}

