/*
 * Decompiled with CFR 0.152.
 */
package io.cbitler.stealingartefacts;

import io.cbitler.stealingartefacts.StealingArtefactsConfig;
import io.cbitler.stealingartefacts.StealingArtefactsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Point;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class StealingArtefactsHouseOverlay
extends Overlay {
    public static final Color CLICKBOX_BORDER = Color.YELLOW;
    public static final Color CLICKBOX_HOVER_BORDER = Color.YELLOW;
    public static final Color CLICKBOX_FILL_COLOR = new Color(0, 255, 0, 50);
    private final Client client;
    private final StealingArtefactsPlugin plugin;
    private final StealingArtefactsConfig config;

    @Inject
    StealingArtefactsHouseOverlay(Client client, StealingArtefactsPlugin plugin, StealingArtefactsConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.currentState == null) {
            return null;
        }
        Point mousePosition = this.client.getMouseCanvasPosition();
        for (GameObject object : this.plugin.markedObjects) {
            if (object.getId() == 27634 && !this.config.highlightLadders() || this.client.getPlane() != object.getWorldLocation().getPlane()) continue;
            OverlayUtil.renderHoverableArea((Graphics2D)graphics, (Shape)object.getClickbox(), (Point)mousePosition, (Color)CLICKBOX_FILL_COLOR, (Color)CLICKBOX_BORDER, (Color)CLICKBOX_HOVER_BORDER);
        }
        return null;
    }
}

