/*
 * Decompiled with CFR 0.152.
 */
package dekvall.pushnotification;

import com.google.common.base.Strings;
import com.google.inject.Provides;
import dekvall.pushnotification.PushNotificationsConfig;
import java.io.IOException;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NotificationFired;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Push Notifications")
public class PushNotificationsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PushNotificationsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private PushNotificationsConfig config;

    protected void startUp() throws Exception {
        log.info("Push Notifications started!");
    }

    protected void shutDown() throws Exception {
        log.info("Push Notifications stopped!");
    }

    @Provides
    PushNotificationsConfig provideConfig(ConfigManager configManager) {
        return (PushNotificationsConfig)configManager.getConfig(PushNotificationsConfig.class);
    }

    @Subscribe
    public void onNotificationFired(NotificationFired event) {
        this.handlePushbullet(event);
        this.handlePushover(event);
    }

    private void handlePushbullet(NotificationFired event) {
        if (Strings.isNullOrEmpty((String)this.config.pushbullet())) {
            return;
        }
        HttpUrl url = new HttpUrl.Builder().scheme("https").host("api.pushbullet.com").addPathSegment("v2").addPathSegment("pushes").build();
        FormBody push = new FormBody.Builder().add("body", "You should probably do something about that..").add("title", event.getMessage()).add("type", "note").build();
        Request request = new Request.Builder().header("User-Agent", "RuneLite").header("Access-Token", this.config.pushbullet()).header("Content-Type", "application/json").header("User-Agent", "RuneLite").post((RequestBody)push).url(url).build();
        PushNotificationsPlugin.sendRequest("Pushbullet", request);
    }

    private void handlePushover(NotificationFired event) {
        if (Strings.isNullOrEmpty((String)this.config.pushover_api()) || Strings.isNullOrEmpty((String)this.config.pushover_user())) {
            return;
        }
        HttpUrl url = new HttpUrl.Builder().scheme("https").host("api.pushover.net").addPathSegment("1").addPathSegment("messages.json").build();
        FormBody push = new FormBody.Builder().add("token", this.config.pushover_api()).add("user", this.config.pushover_user()).add("message", event.getMessage()).build();
        Request request = new Request.Builder().header("User-Agent", "RuneLite").header("Content-Type", "application/json").header("User-Agent", "RuneLite").post((RequestBody)push).url(url).build();
        PushNotificationsPlugin.sendRequest("Pushover", request);
    }

    private static void sendRequest(final String platform, Request request) {
        RuneLiteAPI.CLIENT.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.warn("Error sending {} notification, caused by {}.", (Object)platform, (Object)e.getMessage());
            }

            public void onResponse(Call call, Response response) {
                response.close();
            }
        });
    }
}

