/*
 * Decompiled with CFR 0.152.
 */
package com.MiningSpecialEffectTracker;

import com.MiningSpecialEffectTracker.MiningSpecialEffectTrackerConfig;
import com.MiningSpecialEffectTracker.MiningSpecialEffectTrackerOverlay;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Mining Special Effect Tracker")
public class MiningSpecialEffectTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MiningSpecialEffectTrackerPlugin.class);
    int totalOreMined = 0;
    int totalOreEffect = 0;
    int smithingEffect = 0;
    int totalSmithingEffect = 0;
    int varrockArmourEffect;
    int celestrialRingEffect;
    int miningCapeEffect;
    int miningGlovesEffect;
    float miningDuration = 0.0f;
    boolean inMlm = false;
    public static final Set<Integer> MINING_ANIMATION_IDS = ImmutableSet.of((Object)625, (Object)626, (Object)627, (Object)3873, (Object)629, (Object)628, (Object[])new Integer[]{624, 8313, 7139, 642, 8346, 8887, 4482, 7283, 8347, 8787, 8788, 8789, 6753, 6754, 6755, 3866, 6757, 6756, 6752, 8312, 6758, 335, 8344, 8886, 4481, 7282, 8345, 8786});
    private static final Set<Integer> MOTHERLODE_MAP_REGIONS = ImmutableSet.of((Object)14679, (Object)14680, (Object)14681, (Object)14935, (Object)14936, (Object)14937, (Object[])new Integer[]{15191, 15192, 15193});
    @Inject
    private Client client;
    @Inject
    private MiningSpecialEffectTrackerConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MiningSpecialEffectTrackerOverlay overlay;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.inMlm = this.checkInMlm();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Provides
    MiningSpecialEffectTrackerConfig provideConfig(ConfigManager configManager) {
        return (MiningSpecialEffectTrackerConfig)configManager.getConfig(MiningSpecialEffectTrackerConfig.class);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.inMlm = this.checkInMlm();
        }
    }

    private boolean checkInMlm() {
        int[] currentMapRegions;
        GameState gameState = this.client.getGameState();
        if (gameState != GameState.LOGGED_IN && gameState != GameState.LOADING) {
            return false;
        }
        for (int region : currentMapRegions = this.client.getMapRegions()) {
            if (MOTHERLODE_MAP_REGIONS.contains(region)) continue;
            return false;
        }
        return true;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.inMlm) {
            return;
        }
        if (this.miningDuration > 0.0f) {
            this.miningDuration = (float)((double)this.miningDuration - 0.6);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.inMlm) {
            return;
        }
        if (event.getType() != ChatMessageType.SPAM) {
            return;
        }
        String message = event.getMessage();
        if (message.equals("The Varrock platebody enabled you to mine an additional ore.")) {
            this.incrementOreEffect(1);
            this.incrementOreMined(1);
            this.incrementVarrockEffect(1);
        }
        if (message.equals("Your Celestial ring allows you to mine an additional ore.")) {
            this.incrementOreEffect(1);
            this.incrementOreMined(1);
            this.incrementCelestialEffect(1);
        }
        if (message.equals("Your cape allows you to mine an additional ore.")) {
            this.incrementOreEffect(1);
            this.incrementOreMined(1);
            this.incrementCapeEffect(1);
        }
        if (message.equals("The Varrock platebody enabled you to smelt your next ore simultaneously.")) {
            this.incrementSmithingEffect(1);
        }
        if (message.equals("Your Mining gloves prevent the rock from depleting.")) {
            this.incrementOreEffect(1);
            this.incrementGlovesEffect(1);
        }
        if (message.matches("You manage to mine some(.*)")) {
            this.miningDuration = 300.0f;
            this.incrementOreMined(1);
        }
    }

    public void incrementOreMined(int count) {
        this.totalOreMined += count;
    }

    public void incrementOreEffect(int count) {
        this.totalOreEffect += count;
    }

    public void incrementSmithingEffect(int count) {
        this.totalSmithingEffect += count;
    }

    public void incrementVarrockEffect(int count) {
        this.varrockArmourEffect += count;
    }

    public void incrementCelestialEffect(int count) {
        this.celestrialRingEffect += count;
    }

    public void incrementCapeEffect(int count) {
        this.miningCapeEffect += count;
    }

    public void incrementGlovesEffect(int count) {
        this.miningGlovesEffect += count;
    }

    public boolean checkMining() {
        return MINING_ANIMATION_IDS.contains(this.client.getLocalPlayer().getAnimation());
    }
}

