/*
 * Decompiled with CFR 0.152.
 */
package com.MiningSpecialEffectTracker;

import com.MiningSpecialEffectTracker.MiningSpecialEffectTrackerConfig;
import com.MiningSpecialEffectTracker.MiningSpecialEffectTrackerPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

class MiningSpecialEffectTrackerOverlay
extends OverlayPanel {
    private Client client;
    private MiningSpecialEffectTrackerPlugin plugin;
    private MiningSpecialEffectTrackerConfig config;

    @Inject
    MiningSpecialEffectTrackerOverlay(MiningSpecialEffectTrackerPlugin plugin, Client client, MiningSpecialEffectTrackerConfig config) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, "Configure", "Mining Special Effect Overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.inMlm && (this.plugin.checkMining() || this.plugin.miningDuration > 0.0f)) {
            List elems = this.panelComponent.getChildren();
            elems.clear();
            this.panelComponent.setPreferredSize(new Dimension(160, 200));
            if (this.config.showMiningState()) {
                if (this.plugin.checkMining()) {
                    this.panelComponent.getChildren().add(TitleComponent.builder().text("Mining").color(Color.GREEN).build());
                    this.plugin.miningDuration = 300.0f;
                } else {
                    this.panelComponent.getChildren().add(TitleComponent.builder().text("NOT mining").color(Color.RED).build());
                }
            }
            if (this.config.showTotalEffect()) {
                elems.add(LineComponent.builder().left("Total Effect:").right(String.format("%d", this.plugin.totalOreEffect)).build());
            }
            if (this.config.showTotalOres()) {
                elems.add(LineComponent.builder().left("Total Mined:").right(String.format("%d", this.plugin.totalOreMined)).build());
            }
            if (this.config.showSmithingEffect()) {
                elems.add(LineComponent.builder().left("Smithing Effect:").right(String.format("%d", this.plugin.smithingEffect)).build());
            }
            if (this.config.showVarrockEffect()) {
                elems.add(LineComponent.builder().left("Varrock Armour Effect:").right(String.format("%d", this.plugin.varrockArmourEffect)).build());
            }
            if (this.config.showCelestialEffect()) {
                elems.add(LineComponent.builder().left("Celestial Ring Effect:").right(String.format("%d", this.plugin.celestrialRingEffect)).build());
            }
            if (this.config.showCapeEffect()) {
                elems.add(LineComponent.builder().left("Mining Cape Effect:").right(String.format("%d", this.plugin.miningCapeEffect)).build());
            }
            if (this.config.showGlovesEffect()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Mining Gloves Effect:").right(String.format("%d", this.plugin.miningGlovesEffect)).build());
            }
        }
        return super.render(graphics);
    }
}

