/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.GEFilters;

import com.google.inject.Provides;
import com.salverrs.GEFilters.Filters.BankTabSearchFilter;
import com.salverrs.GEFilters.Filters.InventorySearchFilter;
import com.salverrs.GEFilters.Filters.InventorySetupsSearchFilter;
import com.salverrs.GEFilters.Filters.RecentItemsSearchFilter;
import com.salverrs.GEFilters.Filters.SearchFilter;
import com.salverrs.GEFilters.GEFiltersConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="GE Filters", description="Search filters for the Grand Exchange.", tags={"ge", "filter", "grand", "exchange", "search", "bank", "tag", "inventory", "setups"}, enabledByDefault=true)
public class GEFiltersPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GEFiltersPlugin.class);
    public static final String CONFIG_GROUP = "GE_FILTERS_CONFIG";
    public static final String CONFIG_GROUP_DATA = "GE_FILTERS_CONFIG_DATA";
    public static final String BANK_TAGS_COMP_NAME = "Bank Tags";
    private static final String SEARCH_BUY_PREFIX = "What would you like to buy?";
    public static final String INVENTORY_SETUPS_COMP_NAME = "Inventory Setups";
    private static final int SEARCH_BOX_LOADED_ID = 750;
    private static final int SEARCH_STRING_APPEND_ID = 222;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private GEFiltersConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private EventBus eventBus;
    @Inject
    private BankTabSearchFilter bankTabSearchFilter;
    @Inject
    private InventorySetupsSearchFilter inventorySetupsSearchFilter;
    @Inject
    private RecentItemsSearchFilter recentItemsSearchFilter;
    @Inject
    private InventorySearchFilter inventorySearchFilter;
    @Inject
    private PluginManager pluginManager;
    private List<SearchFilter> filters;

    protected void startUp() throws Exception {
        log.info("GE Filters started!");
        this.clientThread.invoke(() -> {
            this.loadFilters();
            this.tryStartFilters();
        });
    }

    protected void shutDown() throws Exception {
        log.info("GE Filters stopped!");
        this.clientThread.invoke(() -> this.stopFilters());
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 750) {
            this.clientThread.invoke(() -> this.tryStartFilters());
        }
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired event) {
        String[] stringStack;
        if (this.config.hideSearchPrefix() && event.getScriptId() == 222 && (stringStack = this.client.getStringStack())[0].equals(SEARCH_BUY_PREFIX)) {
            stringStack[0] = "";
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals(CONFIG_GROUP)) {
            return;
        }
        this.clientThread.invoke(() -> {
            this.stopFilters();
            this.loadFilters();
            this.tryStartFilters();
        });
    }

    private void loadFilters() {
        this.filters = new ArrayList<SearchFilter>();
        if (this.config.enableBankTagFilter() && this.isPluginEnabled(BANK_TAGS_COMP_NAME)) {
            this.filters.add(this.bankTabSearchFilter);
        }
        if (this.config.enableInventorySetupsFilter() && this.isPluginEnabled(INVENTORY_SETUPS_COMP_NAME)) {
            this.filters.add(this.inventorySetupsSearchFilter);
        }
        if (this.config.enableInventoryFilter()) {
            this.filters.add(this.inventorySearchFilter);
        }
        if (this.config.enableRecentItemsFilter()) {
            this.filters.add(this.recentItemsSearchFilter);
        }
        this.registerFilterEvents();
    }

    private void tryStartFilters() {
        if (this.isSearchVisible()) {
            this.startFilters();
        }
    }

    private void startFilters() {
        int horizontalSpacing = 20 + this.config.filterHorizontalSpacing();
        int xOffset = 0;
        for (SearchFilter filter : this.filters) {
            filter.start(xOffset, 0);
            xOffset += horizontalSpacing;
        }
    }

    private void stopFilters() {
        for (SearchFilter filter : this.filters) {
            filter.stop();
        }
        this.unregisterFilterEvents();
    }

    private void registerFilterEvents() {
        for (SearchFilter filter : this.filters) {
            this.eventBus.register((Object)filter);
        }
    }

    private void unregisterFilterEvents() {
        for (SearchFilter filter : this.filters) {
            this.eventBus.unregister((Object)filter);
        }
    }

    private boolean isPluginEnabled(String pluginName) {
        Collection plugins = this.pluginManager.getPlugins();
        for (Plugin plugin : plugins) {
            String name = plugin.getName();
            if (!name.equals(pluginName)) continue;
            return this.pluginManager.isPluginEnabled(plugin);
        }
        return false;
    }

    private boolean isSearchVisible() {
        Widget widget = this.client.getWidget(WidgetInfo.CHATBOX_GE_SEARCH_RESULTS);
        return widget != null && !widget.isHidden();
    }

    @Provides
    GEFiltersConfig provideConfig(ConfigManager configManager) {
        return (GEFiltersConfig)configManager.getConfig(GEFiltersConfig.class);
    }
}

