/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.GEFilters;

import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="GE_FILTERS_CONFIG")
public interface GEFiltersConfig
extends Config {
    @ConfigSection(name="Filters", description="Grand Exchange search filters.", position=0)
    public static final String filtersSection = "filters";
    @ConfigSection(name="Inventory Setups", description="Toggle item types from Inventory Setups that will be included in the filter.", position=2)
    public static final String inventorySetupsSection = "invsetupsfilter";
    @ConfigSection(name="Preferences", description="Grand Exchange search filter preferences.", position=3)
    public static final String preferencesSection = "preferences";

    @ConfigItem(keyName="enableBankTagFilter", name="Enable Bank Tag Filter", description="Filters GE items by bank tag. Requires the Bank Tag plugin to be enabled.", section="filters", position=0)
    default public boolean enableBankTagFilter() {
        return true;
    }

    @ConfigItem(keyName="enableInventorySetupsFilter", name="Enable Inventory Setups Filter", description="Filters GE items by inventory setups. Requires the Inventory Setups plugin to be enabled.", section="filters", position=1)
    default public boolean enableInventorySetupsFilter() {
        return true;
    }

    @ConfigItem(keyName="enableInventoryFilter", name="Enable Inventory Filter", description="Filters GE items by inventory/equipped items.", section="filters", position=2)
    default public boolean enableInventoryFilter() {
        return true;
    }

    @ConfigItem(keyName="enableRecentItemsFilter", name="Enable Recent Items Filter", description="Filters GE items by recently viewed or recent buy/sell offers.", section="filters", position=3)
    default public boolean enableRecentItemsFilter() {
        return true;
    }

    @ConfigItem(keyName="enableInvSetupsEquipment", name="Equipment", description="Show equipment items in the Inventory Setups filter.", section="invsetupsfilter", position=4)
    default public boolean enableInvSetupsEquipment() {
        return true;
    }

    @ConfigItem(keyName="enableInvSetupsInventory", name="Inventory", description="Show inventory items in the Inventory Setups filter.", section="invsetupsfilter", position=5)
    default public boolean enableInvSetupsInventory() {
        return true;
    }

    @ConfigItem(keyName="enableInvSetupsRunePouch", name="Rune Pouch", description="Show Rune pouch runes in the Inventory Setups filter.", section="invsetupsfilter", position=6)
    default public boolean enableInvSetupsRunePouch() {
        return true;
    }

    @ConfigItem(keyName="enableInvSetupsBoltPouch", name="Bolt Pouch", description="Show Bolt pouch bolts in the Inventory Setups filter.", section="invsetupsfilter", position=7)
    default public boolean enableInvSetupsBoltPouch() {
        return true;
    }

    @ConfigItem(keyName="enableInvSetupsAdditionalItems", name="Additional Filtered Items", description="Show additional filtered items the Inventory Setups filter.", section="invsetupsfilter", position=8)
    default public boolean enableInvSetupsAdditionalItems() {
        return true;
    }

    @ConfigItem(keyName="filterTitleColour", name="Filter Title Colour", description="The text colour for filter titles.", section="preferences", position=9)
    default public Color filterTitleColour() {
        return new Color(178, 0, 0);
    }

    @ConfigItem(keyName="keyPressOverridesFilter", name="Typing Overrides Active Filter", description="When enabled typing will override the currently active filter and perform a regular search.", section="preferences", position=10)
    default public boolean keyPressOverridesFilter() {
        return true;
    }

    @ConfigItem(keyName="hideSearchPrefix", name="Hide Default Search Prefix", description="Hide 'What would you like to buy?' from GE searches.", section="preferences", position=11)
    default public boolean hideSearchPrefix() {
        return true;
    }

    @Range(max=20, min=0)
    @ConfigItem(keyName="filterHorizontalSpacing", name="Horizontal Spacing", description="The horizontal space between filter buttons (px).", section="preferences", position=12)
    default public int filterHorizontalSpacing() {
        return 5;
    }
}

