/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.GEFilters.Filters;

import com.salverrs.GEFilters.Filters.Events.OtherFilterOptionActivated;
import com.salverrs.GEFilters.Filters.Model.FilterOption;
import com.salverrs.GEFilters.Filters.Model.SearchState;
import com.salverrs.GEFilters.GEFiltersConfig;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.ScriptEvent;
import net.runelite.api.events.GrandExchangeSearched;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.ui.JagexColors;

public abstract class SearchFilter {
    public static final int ICON_SIZE = 20;
    private static final String CLEAR_FILTER_OPTION = "Clear Filter";
    private static final String QUEST_HELPER_COMP_WIDGET_NAME = "quest helper";
    private static final String QUEST_HELPER_COMP_NAME = "Quest Helper";
    private static final String QUEST_HELPER_FILTER_OPTION = "View missing items";
    private static final int FILTER_TOGGLE_SOUND_ID = 2266;
    private static final int KEY_PRESS_SCRIPT_ID = 905;
    private static final int ICON_BG_SIZE_OFFSET = 6;
    private static final int ICON_BG_POS_OFFSET = 3;
    private boolean qhEnabled;
    private Widget container;
    private Widget iconWidget;
    private Widget backgroundWidget;
    private Widget titleWidget;
    private Widget searchBoxWidget;
    private FilterOption lastOptionActivated;
    private SearchState lastSearchResults;
    private List<String> filterTitles;
    private String currentTitle;
    private int iconSpriteId;
    private int iconSpriteSizeOffset;
    private boolean filterEnabled;
    protected boolean ready;
    private HashMap<String, FilterOption> filterTitleMap;
    private HashMap<String, FilterOption> filterSearchMap;
    @Inject
    protected ConfigManager configManager;
    @Inject
    protected Client client;
    @Inject
    protected ClientThread clientThread;
    @Inject
    private EventBus eventBus;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private GEFiltersConfig config;

    public void start(int xOffset, int yOffset) {
        if (this.isChatInputHidden()) {
            return;
        }
        if (!this.ready) {
            this.onFilterInitialising();
        }
        this.onFilterStarted();
        this.checkQuestHelperState();
        this.createWidgets(xOffset, yOffset);
        this.refreshFilterMenuOptions(false);
        this.handleReactivation();
        this.ready = true;
    }

    public void stop() {
        this.container = null;
        this.trySetHidden(this.titleWidget, true);
        this.trySetHidden(this.iconWidget, true);
        this.trySetHidden(this.backgroundWidget, true);
        if (this.filterEnabled) {
            this.disableFilter(true);
        }
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed event) {
        if (event.getGroupId() == 465) {
            this.disableFilter(true);
        }
    }

    @Subscribe
    protected void onMenuOptionClicked(MenuOptionClicked event) {
        if (!this.ready) {
            return;
        }
        String optionClicked = event.getMenuOption();
        if (optionClicked.contains(QUEST_HELPER_FILTER_OPTION)) {
            this.disableFilter(true);
            return;
        }
        Widget widget = event.getWidget();
        if (widget != this.backgroundWidget && widget != this.iconWidget) {
            return;
        }
        if (optionClicked.equals(CLEAR_FILTER_OPTION)) {
            this.disableFilter(true);
        } else {
            this.resolveQuestHelperFilterState();
            FilterOption option = this.filterTitleMap.get(optionClicked);
            this.enableFilter(option, false, true);
        }
        this.client.playSoundEffect(2266);
    }

    @Subscribe
    protected void onGrandExchangeSearched(GrandExchangeSearched event) {
        if (!this.ready) {
            return;
        }
        String input = this.client.getVarcStrValue(359);
        if (!this.filterSearchMap.containsKey(input)) {
            return;
        }
        FilterOption option = this.filterSearchMap.get(input);
        event.consume();
        this.onFilterEnabled(option);
    }

    @Subscribe
    protected void onOtherFilterOptionActivated(OtherFilterOptionActivated event) {
        if (!this.ready) {
            return;
        }
        if (event.getSearchFilter() == this && event.getFilterOption() == this.lastOptionActivated) {
            return;
        }
        if (this.filterEnabled) {
            this.disableFilter(false);
        }
    }

    @Subscribe
    private void onScriptPreFired(ScriptPreFired event) {
        if (!(this.ready && this.filterEnabled && this.config.keyPressOverridesFilter())) {
            return;
        }
        if (event.getScriptId() != 905) {
            return;
        }
        if (!this.isItemSearchInput()) {
            return;
        }
        ScriptEvent scriptEvent = event.getScriptEvent();
        int typedKeyChar = scriptEvent.getTypedKeyChar();
        if (typedKeyChar == 0) {
            return;
        }
        String character = Character.toString((char)typedKeyChar);
        this.disableFilter(true);
        this.searchGE(character, false);
    }

    protected abstract void onFilterInitialising();

    protected abstract void onFilterStarted();

    protected abstract void onFilterEnabled(FilterOption var1);

    protected void searchGE(String searchTerm) {
        this.searchGE(searchTerm, true);
    }

    protected void searchGE(String searchTerm, boolean hideSearch) {
        this.client.setVarcStrValue(359, searchTerm);
        this.client.setVarcIntValue(5, 14);
        this.forceUpdateSearch(hideSearch);
    }

    protected void setGESearchResults(short[] itemIds) {
        this.client.setGeSearchResultIndex(0);
        this.client.setGeSearchResultCount(itemIds.length);
        this.client.setGeSearchResultIds(itemIds);
    }

    protected void setTitle(String title) {
        Color titleColour = this.config.filterTitleColour();
        int r = titleColour.getRed();
        int g = titleColour.getGreen();
        int b = titleColour.getBlue();
        String hexColor = String.format("%02x%02x%02x", r, g, b);
        this.currentTitle = title;
        this.titleWidget.setText("<col=" + hexColor + ">" + this.currentTitle + "</col>");
    }

    protected void setFilterOptions(FilterOption ... options) {
        this.filterTitles = new ArrayList<String>();
        this.filterTitleMap = new HashMap();
        this.filterSearchMap = new HashMap();
        for (FilterOption option : options) {
            String title = option.getTitle();
            this.filterTitles.add(title);
            this.filterTitleMap.put(title, option);
            this.filterSearchMap.put(option.getSearchValue(), option);
        }
    }

    protected void setIconSprite(int spriteId, int sizeOffset) {
        this.iconSpriteId = spriteId;
        this.iconSpriteSizeOffset = sizeOffset;
    }

    protected void saveSearchState(String search) {
        this.lastSearchResults = new SearchState(this.currentTitle, search);
    }

    protected boolean hasPreviousSearchState() {
        return this.lastSearchResults != null;
    }

    protected void loadPreviousSearchState() {
        if (this.lastSearchResults == null) {
            return;
        }
        String title = this.lastSearchResults.getTitle();
        String searchVal = this.lastSearchResults.getSearchValue();
        this.setTitle(title);
        if (searchVal != null) {
            this.searchGE(searchVal);
        }
    }

    protected void resetPreviousSearchState() {
        this.lastSearchResults = null;
    }

    protected void forceUpdateSearch(boolean hideSearchBox) {
        this.clientThread.invokeLater(() -> {
            if (this.searchBoxWidget == null) {
                return;
            }
            Object[] scriptArgs = this.searchBoxWidget.getOnKeyListener();
            if (scriptArgs == null) {
                return;
            }
            this.client.runScript(scriptArgs);
            this.searchBoxWidget.setHidden(hideSearchBox);
        });
    }

    protected void setSearchResultsHidden(boolean hidden) {
        Widget resultsContainer = this.client.getWidget(WidgetInfo.CHATBOX_GE_SEARCH_RESULTS);
        if (resultsContainer != null) {
            resultsContainer.setHidden(hidden);
        }
    }

    private void enableFilter(FilterOption option, boolean silent, boolean clearData) {
        if (!this.ready) {
            return;
        }
        this.filterEnabled = true;
        this.refreshFilterMenuOptions(true);
        this.setWidgetActivationState(true, true);
        if (!silent) {
            this.setTitle(option.getTitle());
            this.searchGE(option.getSearchValue());
        }
        if (clearData) {
            option.setData(null);
        }
        this.lastOptionActivated = option;
        this.eventBus.post((Object)new OtherFilterOptionActivated(this, option));
    }

    private void disableFilter(boolean clearSearch) {
        if (!this.ready || !this.filterEnabled) {
            return;
        }
        this.filterEnabled = false;
        this.refreshFilterMenuOptions(false);
        this.resetPreviousSearchState();
        this.filterTitleMap.values().forEach(f -> f.setData(null));
        this.clientThread.invokeLater(() -> this.setWidgetActivationState(false, true));
        if (clearSearch) {
            this.client.setVarcStrValue(359, "");
            this.client.setVarcIntValue(5, 14);
            this.forceUpdateSearch(false);
        }
    }

    private void handleReactivation() {
        if (this.filterEnabled) {
            if (this.hasPreviousSearchState()) {
                this.enableFilter(this.lastOptionActivated, true, false);
                this.loadPreviousSearchState();
            } else {
                this.enableFilter(this.lastOptionActivated, false, false);
            }
        } else {
            this.resetPreviousSearchState();
        }
    }

    private void setWidgetActivationState(boolean filterEnabled, boolean hideSearchBox) {
        if (this.backgroundWidget != null) {
            this.backgroundWidget.setSpriteId(filterEnabled ? 196 : 195);
            this.backgroundWidget.revalidate();
        }
        if (this.searchBoxWidget != null) {
            this.searchBoxWidget.setHidden(hideSearchBox);
        }
        if (this.titleWidget != null) {
            this.titleWidget.setHidden(!filterEnabled);
        }
    }

    private void refreshFilterMenuOptions(boolean showClearOption) {
        this.clearFilterOptions();
        if (showClearOption) {
            this.backgroundWidget.setAction(0, CLEAR_FILTER_OPTION);
        }
        int i = showClearOption ? 1 : 0;
        for (String optionTitle : this.filterTitles) {
            this.backgroundWidget.setAction(i, optionTitle);
            ++i;
        }
    }

    private void clearFilterOptions() {
        for (int i = 0; i <= this.filterTitleMap.size(); ++i) {
            this.backgroundWidget.setAction(i, null);
        }
    }

    private void checkQuestHelperState() {
        Collection plugins = this.pluginManager.getPlugins();
        for (Plugin plugin : plugins) {
            String name = plugin.getName();
            if (!name.equals(QUEST_HELPER_COMP_NAME)) continue;
            this.qhEnabled = this.pluginManager.isPluginEnabled(plugin);
            return;
        }
        this.qhEnabled = false;
    }

    private void resolveQuestHelperFilterState() {
        boolean filterEnabled;
        if (!this.qhEnabled) {
            return;
        }
        Widget[] children = this.container.getChildren();
        Widget qhIcon = null;
        for (int i = 0; i < children.length; ++i) {
            Widget child = children[i];
            if (!child.getName().equals(QUEST_HELPER_COMP_WIDGET_NAME)) continue;
            qhIcon = child;
            break;
        }
        boolean bl = filterEnabled = qhIcon != null && qhIcon.getSpriteId() == 196;
        if (!filterEnabled) {
            return;
        }
        Object[] filterArgs = qhIcon.getOnOpListener();
        this.client.runScript(filterArgs);
    }

    private boolean isChatInputHidden() {
        Widget widget = this.client.getWidget(WidgetInfo.CHATBOX_CONTAINER);
        return widget == null || widget.isHidden();
    }

    private boolean isItemSearchInput() {
        if (this.isChatInputHidden()) {
            return false;
        }
        Widget title = this.client.getWidget(WidgetInfo.CHATBOX_TITLE);
        return title != null && title.isHidden();
    }

    private void createWidgets(int xOffset, int yOffset) {
        this.container = this.client.getWidget(WidgetInfo.CHATBOX_CONTAINER);
        this.searchBoxWidget = this.client.getWidget(WidgetInfo.CHATBOX_FULL_INPUT);
        this.titleWidget = this.createTitleWidget();
        this.backgroundWidget = this.createGraphicWidget(195, 20, 20, xOffset, yOffset);
        this.iconWidget = this.createGraphicWidget(this.iconSpriteId, 14 + this.iconSpriteSizeOffset, 14 + this.iconSpriteSizeOffset, xOffset + 3 - this.iconSpriteSizeOffset / 2, yOffset + 3 - this.iconSpriteSizeOffset / 2);
    }

    private Widget createGraphicWidget(int spriteId, int width, int height, int x, int y) {
        Widget widget = this.container.createChild(-1, 5);
        widget.setOriginalX(x);
        widget.setOriginalY(y);
        widget.setOriginalWidth(width);
        widget.setOriginalHeight(height);
        widget.setSpriteId(spriteId);
        widget.setOnOpListener(new Object[]{10003});
        widget.setHasListener(true);
        widget.revalidate();
        return widget;
    }

    private Widget createTitleWidget() {
        Widget chatBoxWidget = this.client.getWidget(WidgetInfo.CHATBOX_FULL_INPUT);
        Widget widget = this.container.createChild(-1, 4);
        if (chatBoxWidget == null) {
            return widget;
        }
        widget.setOriginalWidth(chatBoxWidget.getWidth());
        widget.setOriginalHeight(chatBoxWidget.getHeight());
        widget.setOriginalX(0);
        widget.setOriginalY(0);
        widget.setTextShadowed(false);
        widget.setXTextAlignment(1);
        widget.setYTextAlignment(1);
        widget.setFontId(496);
        widget.setTextColor(JagexColors.CHAT_GAME_EXAMINE_TEXT_OPAQUE_BACKGROUND.getRGB());
        widget.setHidden(true);
        widget.revalidate();
        return widget;
    }

    private void trySetHidden(Widget widget, boolean hidden) {
        if (widget != null) {
            widget.setHidden(hidden);
        }
    }
}

