/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.GEFilters.Filters;

import com.salverrs.GEFilters.Filters.FilterUtility;
import com.salverrs.GEFilters.Filters.Model.FilterOption;
import com.salverrs.GEFilters.Filters.SearchFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.GrandExchangeOffer;
import net.runelite.api.GrandExchangeOfferState;
import net.runelite.api.events.GrandExchangeOfferChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.http.api.RuneLiteAPI;

public class RecentItemsSearchFilter
extends SearchFilter {
    private static final int MAX_HISTORY_COUNT = 100;
    private static final int SPRITE_ID_MAIN = 1367;
    private static final String RECENT_ITEMS_JSON_KEY = "ge-recent-items";
    private static final String RECENT_BUY_OFFERS_JSON_KEY = "ge-recent-buy-offers";
    private static final String RECENT_SELL_OFFERS_JSON_KEY = "ge-recent-sell-offers";
    private static final String TITLE_RECENTLY_VIEWED = "Recently Viewed";
    private static final String TITLE_RECENT_BUY_OFFERS = "Recent Buy Offers";
    private static final String TITLE_RECENT_SELL_OFFERS = "Recent Sell Offers";
    private static final String SEARCH_BASE_RECENTLY_VIEWED = "recently-viewed-items";
    private static final String SEARCH_BASE_RECENT_BUY_OFFERS = "recent-buy-offers";
    private static final String SEARCH_BASE_RECENT_SELL_OFFERS = "recent-sell-offers";
    private FilterOption recentlyViewed;
    private FilterOption recentBuyOffers;
    private FilterOption recentSellOffers;
    private ArrayList<Short> recentItemIds;
    private ArrayList<Short> recentBuyOffersItemIds;
    private ArrayList<Short> recentSellOffersItemIds;

    @Override
    protected void onFilterInitialising() {
        this.loadRecentItems();
        this.loadRecentBuyOfferItems();
        this.loadRecentSellOfferItems();
        this.recentlyViewed = new FilterOption(TITLE_RECENTLY_VIEWED, SEARCH_BASE_RECENTLY_VIEWED);
        this.recentBuyOffers = new FilterOption(TITLE_RECENT_BUY_OFFERS, SEARCH_BASE_RECENT_BUY_OFFERS);
        this.recentSellOffers = new FilterOption(TITLE_RECENT_SELL_OFFERS, SEARCH_BASE_RECENT_SELL_OFFERS);
        this.setFilterOptions(this.recentlyViewed, this.recentBuyOffers, this.recentSellOffers);
        this.setIconSprite(1367, 0);
    }

    @Override
    protected void onFilterStarted() {
        this.loadRecentItems();
        this.loadRecentBuyOfferItems();
        this.loadRecentSellOfferItems();
    }

    @Override
    protected void onFilterEnabled(FilterOption option) {
        if (option == this.recentlyViewed) {
            this.addItemFilterResults(this.recentItemIds);
        } else if (option == this.recentBuyOffers) {
            this.addItemFilterResults(this.recentBuyOffersItemIds);
        } else if (option == this.recentSellOffers) {
            this.addItemFilterResults(this.recentSellOffersItemIds);
        }
    }

    @Subscribe
    public void onGrandExchangeOfferChanged(GrandExchangeOfferChanged newOfferEvent) {
        if (!this.ready) {
            return;
        }
        GrandExchangeOffer offer = newOfferEvent.getOffer();
        GrandExchangeOfferState offerState = offer.getState();
        if (offerState == GrandExchangeOfferState.BUYING) {
            this.appendToIdList(this.recentBuyOffersItemIds, (short)offer.getItemId());
            this.saveRecentBuyOfferItems();
        } else if (offerState == GrandExchangeOfferState.SELLING) {
            this.appendToIdList(this.recentSellOffersItemIds, (short)offer.getItemId());
            this.saveRecentSellOfferItems();
        }
    }

    @Subscribe
    protected void onVarbitChanged(VarbitChanged event) {
        if (!this.ready) {
            return;
        }
        if (event.getVarpId() != 1151) {
            return;
        }
        int recentId = this.client.getVarpValue(1151);
        if (recentId == -1 || recentId == 0) {
            return;
        }
        this.appendToIdList(this.recentItemIds, (short)recentId);
        this.saveRecentItems();
    }

    private void appendToIdList(List<Short> itemList, short itemId) {
        int existingIndex = itemList.indexOf(itemId);
        if (existingIndex != -1) {
            itemList.remove(existingIndex);
        }
        itemList.add(0, itemId);
        if (itemList.size() == 100) {
            itemList.remove(99);
        }
    }

    private void addItemFilterResults(ArrayList<Short> items) {
        if (items == null || items.size() == 0) {
            return;
        }
        short[] itemIds = FilterUtility.getPrimitiveShortArray(items);
        this.setGESearchResults(itemIds);
    }

    private void saveRecentItems() {
        this.saveItemIdsToConfig(this.recentItemIds, RECENT_ITEMS_JSON_KEY);
    }

    private void saveRecentBuyOfferItems() {
        this.saveItemIdsToConfig(this.recentBuyOffersItemIds, RECENT_BUY_OFFERS_JSON_KEY);
    }

    private void saveRecentSellOfferItems() {
        this.saveItemIdsToConfig(this.recentSellOffersItemIds, RECENT_SELL_OFFERS_JSON_KEY);
    }

    private void saveItemIdsToConfig(List<Short> itemIds, String configKey) {
        Short[] items = new Short[itemIds.size()];
        itemIds.toArray(items);
        String json = RuneLiteAPI.GSON.toJson((Object)items);
        this.configManager.setConfiguration("GE_FILTERS_CONFIG_DATA", configKey, json);
    }

    private void loadRecentItems() {
        this.recentItemIds = this.loadItemIdsFromConfig(RECENT_ITEMS_JSON_KEY);
    }

    private void loadRecentBuyOfferItems() {
        this.recentBuyOffersItemIds = this.loadItemIdsFromConfig(RECENT_BUY_OFFERS_JSON_KEY);
    }

    private void loadRecentSellOfferItems() {
        this.recentSellOffersItemIds = this.loadItemIdsFromConfig(RECENT_SELL_OFFERS_JSON_KEY);
    }

    private ArrayList<Short> loadItemIdsFromConfig(String configKey) {
        String itemsJson = this.configManager.getConfiguration("GE_FILTERS_CONFIG_DATA", configKey);
        if (itemsJson == null || itemsJson.equals("")) {
            return new ArrayList<Short>();
        }
        Short[] recentItems = (Short[])RuneLiteAPI.GSON.fromJson(itemsJson, Short[].class);
        return new ArrayList<Short>(Arrays.asList(recentItems));
    }
}

