/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.GEFilters.Filters.Model.InventorySetups.Serialization;

import com.salverrs.GEFilters.Filters.Model.InventorySetups.InventorySetup;
import com.salverrs.GEFilters.Filters.Model.InventorySetups.InventorySetupsItem;
import com.salverrs.GEFilters.Filters.Model.InventorySetups.Serialization.InventorySetupItemSerializable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class InventorySetupSerializable {
    private final List<InventorySetupItemSerializable> inv;
    private final List<InventorySetupItemSerializable> eq;
    @Nullable
    private final List<InventorySetupItemSerializable> rp;
    @Nullable
    private final List<InventorySetupItemSerializable> bp;
    @Nullable
    private final Map<Integer, InventorySetupItemSerializable> afi;
    private final String name;
    @Nullable
    private final String notes;
    private final Color hc;
    @Nullable
    private final Boolean hd;
    @Nullable
    private final Color dc;
    @Nullable
    private final Boolean fb;
    @Nullable
    private final Boolean uh;
    @Nullable
    private final Integer sb;
    @Nullable
    private final Boolean fv;
    @Nullable
    private final Integer iId;

    public static InventorySetupSerializable convertFromInventorySetup(InventorySetup inventorySetup) {
        List<InventorySetupItemSerializable> inv = InventorySetupSerializable.convertListFromInventorySetup(inventorySetup.getInventory());
        List<InventorySetupItemSerializable> eq = InventorySetupSerializable.convertListFromInventorySetup(inventorySetup.getEquipment());
        List<InventorySetupItemSerializable> rp = InventorySetupSerializable.convertListFromInventorySetup(inventorySetup.getRune_pouch());
        List<InventorySetupItemSerializable> bp = InventorySetupSerializable.convertListFromInventorySetup(inventorySetup.getBoltPouch());
        HashMap<Integer, InventorySetupItemSerializable> afi = null;
        if (!inventorySetup.getAdditionalFilteredItems().isEmpty()) {
            afi = new HashMap<Integer, InventorySetupItemSerializable>();
            for (Integer key : inventorySetup.getAdditionalFilteredItems().keySet()) {
                afi.put(key, InventorySetupItemSerializable.convertFromInventorySetupItem(inventorySetup.getAdditionalFilteredItems().get(key)));
            }
        }
        String name = inventorySetup.getName();
        String notes = !inventorySetup.getNotes().isEmpty() ? inventorySetup.getNotes() : null;
        Color hc = inventorySetup.getHighlightColor();
        Boolean hd = inventorySetup.isHighlightDifference() ? Boolean.TRUE : null;
        Color dc = inventorySetup.getDisplayColor();
        Boolean fb = inventorySetup.isFilterBank() ? Boolean.TRUE : null;
        Boolean uh = inventorySetup.isUnorderedHighlight() ? Boolean.TRUE : null;
        Integer sb = inventorySetup.getSpellBook() != 0 ? Integer.valueOf(inventorySetup.getSpellBook()) : null;
        Boolean fv = inventorySetup.isFavorite() ? Boolean.TRUE : null;
        Integer iId = inventorySetup.getIconID() > 0 ? Integer.valueOf(inventorySetup.getIconID()) : null;
        return new InventorySetupSerializable(inv, eq, rp, bp, afi, name, notes, hc, hd, dc, fb, uh, sb, fv, iId);
    }

    private static List<InventorySetupItemSerializable> convertListFromInventorySetup(List<InventorySetupsItem> items) {
        ArrayList<InventorySetupItemSerializable> iss_list = null;
        if (items != null) {
            iss_list = new ArrayList<InventorySetupItemSerializable>();
            for (InventorySetupsItem item : items) {
                iss_list.add(InventorySetupItemSerializable.convertFromInventorySetupItem(item));
            }
        }
        return iss_list;
    }

    private static List<InventorySetupsItem> convertListToInventorySetup(List<InventorySetupItemSerializable> iss_items) {
        ArrayList<InventorySetupsItem> itemList = null;
        if (iss_items != null) {
            itemList = new ArrayList<InventorySetupsItem>();
            for (InventorySetupItemSerializable iss_item : iss_items) {
                itemList.add(InventorySetupItemSerializable.convertToInventorySetupItem(iss_item));
            }
        }
        return itemList;
    }

    public static InventorySetup convertToInventorySetup(InventorySetupSerializable iss) {
        List<InventorySetupsItem> inv = InventorySetupSerializable.convertListToInventorySetup(iss.getInv());
        List<InventorySetupsItem> eq = InventorySetupSerializable.convertListToInventorySetup(iss.getEq());
        List<InventorySetupsItem> rp = InventorySetupSerializable.convertListToInventorySetup(iss.getRp());
        List<InventorySetupsItem> bp = InventorySetupSerializable.convertListToInventorySetup(iss.getBp());
        HashMap<Integer, InventorySetupsItem> afi = new HashMap<Integer, InventorySetupsItem>();
        if (iss.getAfi() != null) {
            for (Integer key : iss.getAfi().keySet()) {
                afi.put(key, InventorySetupItemSerializable.convertToInventorySetupItem(iss.getAfi().get(key)));
            }
        }
        String name = iss.getName();
        String notes = iss.getNotes() != null ? iss.getNotes() : "";
        Color hc = iss.getHc();
        boolean hd = iss.getHd() != null ? iss.getHd() : Boolean.FALSE;
        Color dc = iss.getDc();
        boolean fb = iss.getFb() != null ? iss.getFb() : Boolean.FALSE;
        boolean uh = iss.getUh() != null ? iss.getUh() : Boolean.FALSE;
        int sb = iss.getSb() != null ? iss.getSb() : 0;
        boolean fv = iss.getFv() != null ? iss.getFv() : Boolean.FALSE;
        int iId = iss.getIId() != null ? iss.getIId() : -1;
        return new InventorySetup(inv, eq, rp, bp, afi, name, notes, hc, hd, dc, fb, uh, sb, fv, iId);
    }

    public InventorySetupSerializable(List<InventorySetupItemSerializable> inv, List<InventorySetupItemSerializable> eq, @Nullable List<InventorySetupItemSerializable> rp, @Nullable List<InventorySetupItemSerializable> bp, @Nullable Map<Integer, InventorySetupItemSerializable> afi, String name, @Nullable String notes, Color hc, @Nullable Boolean hd, @Nullable Color dc, @Nullable Boolean fb, @Nullable Boolean uh, @Nullable Integer sb, @Nullable Boolean fv, @Nullable Integer iId) {
        this.inv = inv;
        this.eq = eq;
        this.rp = rp;
        this.bp = bp;
        this.afi = afi;
        this.name = name;
        this.notes = notes;
        this.hc = hc;
        this.hd = hd;
        this.dc = dc;
        this.fb = fb;
        this.uh = uh;
        this.sb = sb;
        this.fv = fv;
        this.iId = iId;
    }

    public List<InventorySetupItemSerializable> getInv() {
        return this.inv;
    }

    public List<InventorySetupItemSerializable> getEq() {
        return this.eq;
    }

    @Nullable
    public List<InventorySetupItemSerializable> getRp() {
        return this.rp;
    }

    @Nullable
    public List<InventorySetupItemSerializable> getBp() {
        return this.bp;
    }

    @Nullable
    public Map<Integer, InventorySetupItemSerializable> getAfi() {
        return this.afi;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getNotes() {
        return this.notes;
    }

    public Color getHc() {
        return this.hc;
    }

    @Nullable
    public Boolean getHd() {
        return this.hd;
    }

    @Nullable
    public Color getDc() {
        return this.dc;
    }

    @Nullable
    public Boolean getFb() {
        return this.fb;
    }

    @Nullable
    public Boolean getUh() {
        return this.uh;
    }

    @Nullable
    public Integer getSb() {
        return this.sb;
    }

    @Nullable
    public Boolean getFv() {
        return this.fv;
    }

    @Nullable
    public Integer getIId() {
        return this.iId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InventorySetupSerializable)) {
            return false;
        }
        InventorySetupSerializable other = (InventorySetupSerializable)o;
        Boolean this$hd = this.getHd();
        Boolean other$hd = other.getHd();
        if (this$hd == null ? other$hd != null : !((Object)this$hd).equals(other$hd)) {
            return false;
        }
        Boolean this$fb = this.getFb();
        Boolean other$fb = other.getFb();
        if (this$fb == null ? other$fb != null : !((Object)this$fb).equals(other$fb)) {
            return false;
        }
        Boolean this$uh = this.getUh();
        Boolean other$uh = other.getUh();
        if (this$uh == null ? other$uh != null : !((Object)this$uh).equals(other$uh)) {
            return false;
        }
        Integer this$sb = this.getSb();
        Integer other$sb = other.getSb();
        if (this$sb == null ? other$sb != null : !((Object)this$sb).equals(other$sb)) {
            return false;
        }
        Boolean this$fv = this.getFv();
        Boolean other$fv = other.getFv();
        if (this$fv == null ? other$fv != null : !((Object)this$fv).equals(other$fv)) {
            return false;
        }
        Integer this$iId = this.getIId();
        Integer other$iId = other.getIId();
        if (this$iId == null ? other$iId != null : !((Object)this$iId).equals(other$iId)) {
            return false;
        }
        List<InventorySetupItemSerializable> this$inv = this.getInv();
        List<InventorySetupItemSerializable> other$inv = other.getInv();
        if (this$inv == null ? other$inv != null : !((Object)this$inv).equals(other$inv)) {
            return false;
        }
        List<InventorySetupItemSerializable> this$eq = this.getEq();
        List<InventorySetupItemSerializable> other$eq = other.getEq();
        if (this$eq == null ? other$eq != null : !((Object)this$eq).equals(other$eq)) {
            return false;
        }
        List<InventorySetupItemSerializable> this$rp = this.getRp();
        List<InventorySetupItemSerializable> other$rp = other.getRp();
        if (this$rp == null ? other$rp != null : !((Object)this$rp).equals(other$rp)) {
            return false;
        }
        List<InventorySetupItemSerializable> this$bp = this.getBp();
        List<InventorySetupItemSerializable> other$bp = other.getBp();
        if (this$bp == null ? other$bp != null : !((Object)this$bp).equals(other$bp)) {
            return false;
        }
        Map<Integer, InventorySetupItemSerializable> this$afi = this.getAfi();
        Map<Integer, InventorySetupItemSerializable> other$afi = other.getAfi();
        if (this$afi == null ? other$afi != null : !((Object)this$afi).equals(other$afi)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$notes = this.getNotes();
        String other$notes = other.getNotes();
        if (this$notes == null ? other$notes != null : !this$notes.equals(other$notes)) {
            return false;
        }
        Color this$hc = this.getHc();
        Color other$hc = other.getHc();
        if (this$hc == null ? other$hc != null : !((Object)this$hc).equals(other$hc)) {
            return false;
        }
        Color this$dc = this.getDc();
        Color other$dc = other.getDc();
        return !(this$dc == null ? other$dc != null : !((Object)this$dc).equals(other$dc));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $hd = this.getHd();
        result = result * 59 + ($hd == null ? 43 : ((Object)$hd).hashCode());
        Boolean $fb = this.getFb();
        result = result * 59 + ($fb == null ? 43 : ((Object)$fb).hashCode());
        Boolean $uh = this.getUh();
        result = result * 59 + ($uh == null ? 43 : ((Object)$uh).hashCode());
        Integer $sb = this.getSb();
        result = result * 59 + ($sb == null ? 43 : ((Object)$sb).hashCode());
        Boolean $fv = this.getFv();
        result = result * 59 + ($fv == null ? 43 : ((Object)$fv).hashCode());
        Integer $iId = this.getIId();
        result = result * 59 + ($iId == null ? 43 : ((Object)$iId).hashCode());
        List<InventorySetupItemSerializable> $inv = this.getInv();
        result = result * 59 + ($inv == null ? 43 : ((Object)$inv).hashCode());
        List<InventorySetupItemSerializable> $eq = this.getEq();
        result = result * 59 + ($eq == null ? 43 : ((Object)$eq).hashCode());
        List<InventorySetupItemSerializable> $rp = this.getRp();
        result = result * 59 + ($rp == null ? 43 : ((Object)$rp).hashCode());
        List<InventorySetupItemSerializable> $bp = this.getBp();
        result = result * 59 + ($bp == null ? 43 : ((Object)$bp).hashCode());
        Map<Integer, InventorySetupItemSerializable> $afi = this.getAfi();
        result = result * 59 + ($afi == null ? 43 : ((Object)$afi).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : $notes.hashCode());
        Color $hc = this.getHc();
        result = result * 59 + ($hc == null ? 43 : ((Object)$hc).hashCode());
        Color $dc = this.getDc();
        result = result * 59 + ($dc == null ? 43 : ((Object)$dc).hashCode());
        return result;
    }

    public String toString() {
        return "InventorySetupSerializable(inv=" + this.getInv() + ", eq=" + this.getEq() + ", rp=" + this.getRp() + ", bp=" + this.getBp() + ", afi=" + this.getAfi() + ", name=" + this.getName() + ", notes=" + this.getNotes() + ", hc=" + this.getHc() + ", hd=" + this.getHd() + ", dc=" + this.getDc() + ", fb=" + this.getFb() + ", uh=" + this.getUh() + ", sb=" + this.getSb() + ", fv=" + this.getFv() + ", iId=" + this.getIId() + ")";
    }
}

