/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.GEFilters.Filters;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.salverrs.GEFilters.Filters.FilterUtility;
import com.salverrs.GEFilters.Filters.Model.FilterOption;
import com.salverrs.GEFilters.Filters.Model.GeSearch;
import com.salverrs.GEFilters.Filters.Model.GeSearchResultWidget;
import com.salverrs.GEFilters.Filters.Model.InventorySetups.InventorySetup;
import com.salverrs.GEFilters.Filters.Model.InventorySetups.InventorySetupsItem;
import com.salverrs.GEFilters.Filters.Model.InventorySetups.Serialization.InventorySetupItemSerializable;
import com.salverrs.GEFilters.Filters.Model.InventorySetups.Serialization.InventorySetupItemSerializableTypeAdapter;
import com.salverrs.GEFilters.Filters.Model.InventorySetups.Serialization.InventorySetupSerializable;
import com.salverrs.GEFilters.Filters.Model.InventorySetups.Serialization.LongTypeAdapter;
import com.salverrs.GEFilters.Filters.SearchFilter;
import com.salverrs.GEFilters.GEFiltersConfig;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import joptsimple.internal.Strings;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;

public class InventorySetupsSearchFilter
extends SearchFilter {
    public static final String INVENTORY_SETUPS_CONFIG_GROUP = "inventorysetups";
    public static final String INVENTORY_SETUPS_CONFIG_KEY = "setupsV2";
    private static final int SPRITE_ID_MAIN = 901;
    private static final String TITLE_MAIN = "Inventory Setups";
    private static final String SEARCH_BASE_MAIN = "inventory-setups";
    private static final String INV_SETUPS_MENU_IDENTIFIER = "Open setup";
    private static final String SETUPS_EXCEPTION_JSON_KEY = "inventory-setups-exceptions";
    private FilterOption inventorySetupsFilter;
    private boolean bankOpen = false;
    private List<String> setupExceptions = new ArrayList<String>();
    @Inject
    public Gson gson;
    @Inject
    private GEFiltersConfig config;

    @Override
    protected void onFilterInitialising() {
        this.inventorySetupsFilter = new FilterOption(TITLE_MAIN, SEARCH_BASE_MAIN);
        this.setFilterOptions(this.inventorySetupsFilter);
        this.setIconSprite(901, 0);
        this.gson = this.gson.newBuilder().registerTypeAdapter(Long.TYPE, (Object)new LongTypeAdapter()).create();
        this.gson = this.gson.newBuilder().registerTypeAdapter(InventorySetupItemSerializable.class, (Object)new InventorySetupItemSerializableTypeAdapter()).create();
    }

    @Override
    protected void onFilterStarted() {
        this.loadSetupExceptions();
    }

    @Override
    protected void onFilterEnabled(FilterOption option) {
        if (option == this.inventorySetupsFilter) {
            if (option.getData() != null) {
                this.generateSetupResults((String)option.getData());
            } else {
                this.addInvSetupsFilterOptionResults();
            }
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 12) {
            this.bankOpen = true;
        }
    }

    @Override
    public void onWidgetClosed(WidgetClosed event) {
        super.onWidgetClosed(event);
        if (event.getGroupId() == 12) {
            this.bankOpen = false;
        }
    }

    @Subscribe
    protected void onClientTick(ClientTick clientTick) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        if (!this.bankOpen) {
            return;
        }
        ArrayList<MenuEntry> entries = new ArrayList<MenuEntry>(Arrays.asList(this.client.getMenuEntries()));
        boolean isSetupsMenu = false;
        for (MenuEntry entry : entries) {
            String option = entry.getOption();
            if (!option.contains(INV_SETUPS_MENU_IDENTIFIER)) continue;
            isSetupsMenu = true;
            break;
        }
        if (!isSetupsMenu) {
            return;
        }
        List<String> setupNames = this.getInventorySetupNames();
        MenuEntry parent = this.client.createMenuEntry(-1).setOption("GE Filters Setups").setTarget("").setType(MenuAction.RUNELITE_SUBMENU);
        for (String setup : setupNames) {
            if (this.setupExceptions.contains(setup)) {
                this.client.createMenuEntry(-1).setOption("Include").setTarget(setup).setType(MenuAction.RUNELITE).setParent(parent).onClick(this.removeSetupFromExceptions(setup));
                continue;
            }
            this.client.createMenuEntry(-1).setOption("Exclude").setTarget(setup).setType(MenuAction.RUNELITE).setParent(parent).onClick(this.addSetupToExceptions(setup));
        }
    }

    private void addInvSetupsFilterOptionResults() {
        ArrayList<GeSearch> setupFilters = new ArrayList<GeSearch>();
        List<String> setupNames = this.getInventorySetupNames();
        if (setupNames == null || setupNames.size() == 0) {
            return;
        }
        for (String setup : setupNames) {
            if (this.setupExceptions.contains(setup)) continue;
            setupFilters.add(new GeSearch(setup, 901));
        }
        this.setGESearchResults(this.getEmptySearchResults(setupFilters.size()));
        this.setSearchResultsHidden(true);
        this.clientThread.invokeLater(() -> {
            List<GeSearchResultWidget> searchResultWidgets = this.getGeSearchResults();
            this.generateInvSetupsResults(setupFilters, searchResultWidgets);
            this.setSearchResultsHidden(false);
        });
    }

    private void generateInvSetupsResults(List<GeSearch> filters, List<GeSearchResultWidget> searchResults) {
        if (searchResults.size() == 0) {
            return;
        }
        int resultIndex = 0;
        int resultSize = searchResults.size();
        for (GeSearch filter : filters) {
            if (resultIndex == resultSize) break;
            String setupName = filter.getName();
            GeSearchResultWidget searchResult = searchResults.get(resultIndex);
            searchResult.setTitleText(setupName);
            searchResult.setTooltipText(setupName);
            searchResult.setSpriteId(filter.getIconItemId());
            searchResult.setSpriteSize(22, 24);
            searchResult.setSpriteOffset(5, 2);
            searchResult.setOnOpListener(e -> {
                String title = "Inventory Setups - " + setupName;
                this.inventorySetupsFilter.setData(setupName);
                this.searchGE(this.inventorySetupsFilter.getSearchValue());
                this.setTitle(title);
            });
            ++resultIndex;
        }
    }

    private void generateSetupResults(String setupName) {
        String title = "Inventory Setups - " + setupName;
        InventorySetup setup = this.getInventorySetup(setupName);
        if (setup == null) {
            return;
        }
        List<InventorySetupsItem> invItems = setup.getInventory();
        List<InventorySetupsItem> equipmentItems = setup.getEquipment();
        List<InventorySetupsItem> runePouchItems = setup.getRune_pouch();
        List<InventorySetupsItem> boltPouchItems = setup.getBoltPouch();
        ArrayList<InventorySetupsItem> additionalFilteredItems = new ArrayList<InventorySetupsItem>(setup.getAdditionalFilteredItems().values());
        ArrayList<Short> itemIds = new ArrayList<Short>();
        if (this.config.enableInvSetupsEquipment() && equipmentItems != null) {
            itemIds.addAll(this.getSetupItemIds(equipmentItems));
        }
        if (this.config.enableInvSetupsInventory() && invItems != null) {
            itemIds.addAll(this.getSetupItemIds(invItems));
        }
        if (this.config.enableInvSetupsRunePouch() && runePouchItems != null) {
            itemIds.addAll(this.getSetupItemIds(runePouchItems));
        }
        if (this.config.enableInvSetupsBoltPouch() && boltPouchItems != null) {
            itemIds.addAll(this.getSetupItemIds(boltPouchItems));
        }
        if (this.config.enableInvSetupsAdditionalItems() && additionalFilteredItems != null) {
            itemIds.addAll(this.getSetupItemIds(additionalFilteredItems));
        }
        this.setTitle(title);
        this.addInventorySetupItemResults(itemIds);
        this.saveSearchState(SEARCH_BASE_MAIN);
    }

    private List<GeSearchResultWidget> getGeSearchResults() {
        ArrayList<GeSearchResultWidget> results = new ArrayList<GeSearchResultWidget>();
        Widget[] geSearchResultWidgets = this.client.getWidget(WidgetInfo.CHATBOX_GE_SEARCH_RESULTS).getDynamicChildren();
        LinkedList<Widget> widgetQueue = new LinkedList<Widget>();
        for (Widget w : geSearchResultWidgets) {
            widgetQueue.add(w);
            if (widgetQueue.size() != 3) continue;
            Widget container = (Widget)widgetQueue.remove();
            Widget title = (Widget)widgetQueue.remove();
            Widget icon = (Widget)widgetQueue.remove();
            short itemId = (short)icon.getItemId();
            results.add(new GeSearchResultWidget(container, title, icon, itemId));
        }
        return results;
    }

    private Consumer<MenuEntry> addSetupToExceptions(String setup) {
        return e -> {
            if (this.setupExceptions.contains(setup)) {
                return;
            }
            this.setupExceptions.add(setup);
            this.saveSetupExceptions();
        };
    }

    private Consumer<MenuEntry> removeSetupFromExceptions(String setup) {
        return e -> {
            if (!this.setupExceptions.contains(setup)) {
                return;
            }
            this.setupExceptions.remove(setup);
            this.saveSetupExceptions();
        };
    }

    private void saveSetupExceptions() {
        String[] setupExc = new String[this.setupExceptions.size()];
        this.setupExceptions.toArray(setupExc);
        String json = this.gson.toJson((Object)setupExc);
        this.configManager.setConfiguration("GE_FILTERS_CONFIG_DATA", SETUPS_EXCEPTION_JSON_KEY, json);
    }

    private void loadSetupExceptions() {
        String setupExceptionsJson = this.configManager.getConfiguration("GE_FILTERS_CONFIG_DATA", SETUPS_EXCEPTION_JSON_KEY);
        if (setupExceptionsJson == null || setupExceptionsJson.equals("")) {
            this.setupExceptions = new ArrayList<String>();
        } else {
            String[] setupExc = (String[])this.gson.fromJson(setupExceptionsJson, String[].class);
            this.setupExceptions = new ArrayList<String>(Arrays.asList(setupExc));
        }
    }

    private short[] getEmptySearchResults(int size) {
        short[] ids = new short[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = 0;
        }
        return ids;
    }

    private InventorySetup getInventorySetup(String name) {
        return this.getInventorySetups().stream().filter(s -> s.getName().equals(name)).findAny().orElse(null);
    }

    private List<String> getInventorySetupNames() {
        return this.getInventorySetups().stream().map(s -> s.getName()).collect(Collectors.toList());
    }

    private List<InventorySetup> getInventorySetups() {
        String storedSetups = this.configManager.getConfiguration(INVENTORY_SETUPS_CONFIG_GROUP, INVENTORY_SETUPS_CONFIG_KEY);
        if (Strings.isNullOrEmpty((String)storedSetups)) {
            return null;
        }
        try {
            Type type = new TypeToken<ArrayList<InventorySetupSerializable>>(){}.getType();
            ArrayList issList = new ArrayList((Collection)this.gson.fromJson(storedSetups, type));
            ArrayList<InventorySetup> setups = new ArrayList<InventorySetup>();
            for (InventorySetupSerializable iss : issList) {
                setups.add(InventorySetupSerializable.convertToInventorySetup(iss));
            }
            return setups;
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<Short> getSetupItemIds(List<InventorySetupsItem> items) {
        return items.stream().map(i -> (short)i.getId()).collect(Collectors.toList());
    }

    private void addInventorySetupItemResults(List<Short> itemIds) {
        ArrayList<Short> finalItems = new ArrayList<Short>();
        for (Short id : itemIds) {
            if (id == -1) continue;
            ItemComposition composition = this.client.getItemDefinition((int)id.shortValue());
            ItemComposition unnotedComposition = null;
            int notedId = composition.getLinkedNoteId();
            if (notedId != -1) {
                unnotedComposition = this.client.getItemDefinition(notedId);
            }
            if (finalItems.contains(id) || finalItems.contains((short)notedId)) continue;
            if (composition.isTradeable()) {
                finalItems.add(id);
                continue;
            }
            if (unnotedComposition == null || !unnotedComposition.isTradeable()) continue;
            finalItems.add((short)notedId);
        }
        short[] itemResultIds = FilterUtility.getPrimitiveShortArray(finalItems);
        this.setGESearchResults(itemResultIds);
    }
}

