/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.GEFilters.Filters;

import com.salverrs.GEFilters.Filters.FilterUtility;
import com.salverrs.GEFilters.Filters.Model.FilterOption;
import com.salverrs.GEFilters.Filters.SearchFilter;
import java.util.ArrayList;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;

public class InventorySearchFilter
extends SearchFilter {
    private static final int SPRITE_ID_MAIN = 900;
    private static final String TITLE_INVENTORY = "Inventory Items";
    private static final String TITLE_EQUIPMENT = "Equipped Items";
    private static final String SEARCH_BASE_INVENTORY = "inventory-items";
    private static final String SEARCH_BASE_EQUIPMENT = "equipped-items";
    private FilterOption inventoryFilter;
    private FilterOption equipmentFilter;

    @Override
    protected void onFilterInitialising() {
        this.inventoryFilter = new FilterOption(TITLE_INVENTORY, SEARCH_BASE_INVENTORY);
        this.equipmentFilter = new FilterOption(TITLE_EQUIPMENT, SEARCH_BASE_EQUIPMENT);
        this.setFilterOptions(this.inventoryFilter, this.equipmentFilter);
        this.setIconSprite(900, 0);
    }

    @Override
    protected void onFilterStarted() {
    }

    @Override
    protected void onFilterEnabled(FilterOption option) {
        if (option == this.inventoryFilter) {
            this.addInventoryContainerResults(InventoryID.INVENTORY);
        } else if (option == this.equipmentFilter) {
            this.addInventoryContainerResults(InventoryID.EQUIPMENT);
        }
    }

    private void addInventoryContainerResults(InventoryID inventoryID) {
        ItemContainer container = this.client.getItemContainer(inventoryID);
        if (container == null) {
            return;
        }
        Item[] items = container.getItems();
        ArrayList<Short> itemIds = new ArrayList<Short>();
        for (Item i : items) {
            int id = i.getId();
            if (itemIds.contains((short)id)) continue;
            ItemComposition composition = this.client.getItemDefinition(id);
            ItemComposition unnotedComposition = null;
            int notedId = composition.getLinkedNoteId();
            if (notedId != -1) {
                unnotedComposition = this.client.getItemDefinition(notedId);
            }
            if (composition.isTradeable()) {
                itemIds.add((short)id);
                continue;
            }
            if (unnotedComposition == null || !unnotedComposition.isTradeable()) continue;
            itemIds.add((short)notedId);
        }
        short[] itemResultIds = FilterUtility.getPrimitiveShortArray(itemIds);
        this.setGESearchResults(itemResultIds);
    }
}

