/*
 * Decompiled with CFR 0.152.
 */
package com.salverrs.GEFilters.Filters;

import com.google.common.base.MoreObjects;
import com.salverrs.GEFilters.Filters.Model.FilterOption;
import com.salverrs.GEFilters.Filters.Model.GeSearch;
import com.salverrs.GEFilters.Filters.Model.GeSearchResultWidget;
import com.salverrs.GEFilters.Filters.SearchFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;
import net.runelite.http.api.RuneLiteAPI;

public class BankTabSearchFilter
extends SearchFilter {
    private static final int SPRITE_ID_MAIN = 1453;
    private static final String TITLE_MAIN = "Bank Tags";
    private static final String SEARCH_BASE_MAIN = "bank-tags";
    private static final String TAG_TAB_MENU_IDENTIFIER = "Export tag tab";
    private static final String TAG_EXCEPTION_JSON_KEY = "bank-tags-exceptions";
    private boolean bankOpen = false;
    private FilterOption bankTabFilter;
    private List<String> tagExceptions = new ArrayList<String>();

    @Override
    protected void onFilterInitialising() {
        this.bankTabFilter = new FilterOption(TITLE_MAIN, SEARCH_BASE_MAIN);
        this.setFilterOptions(this.bankTabFilter);
        this.setIconSprite(1453, -1);
    }

    @Override
    protected void onFilterStarted() {
        this.loadTagExceptions();
    }

    @Override
    protected void onFilterEnabled(FilterOption option) {
        if (option == this.bankTabFilter) {
            this.addBankTabFilterOptionResults();
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 12) {
            this.bankOpen = true;
        }
    }

    @Override
    public void onWidgetClosed(WidgetClosed event) {
        super.onWidgetClosed(event);
        if (event.getGroupId() == 12) {
            this.bankOpen = false;
        }
    }

    @Subscribe
    protected void onClientTick(ClientTick clientTick) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        if (!this.bankOpen) {
            return;
        }
        ArrayList<MenuEntry> entries = new ArrayList<MenuEntry>(Arrays.asList(this.client.getMenuEntries()));
        String targetFormatted = null;
        String targetTag = null;
        boolean isTagMenu = false;
        for (MenuEntry entry : entries) {
            String option = entry.getOption();
            if (!option.contains(TAG_TAB_MENU_IDENTIFIER)) continue;
            String entryTarget = entry.getTarget();
            String tagName = Text.removeTags((String)entry.getTarget()).replace("\u00a0", " ");
            isTagMenu = true;
            targetFormatted = entryTarget;
            targetTag = tagName;
            break;
        }
        if (!isTagMenu || targetTag == null) {
            return;
        }
        if (this.tagExceptions.contains(targetTag)) {
            this.client.createMenuEntry(-1).setOption("Include on GE Filters").setTarget(targetFormatted).setType(MenuAction.RUNELITE).onClick(this.removeTagFromExceptions(targetTag));
        } else {
            this.client.createMenuEntry(-1).setOption("Exclude from GE Filters").setTarget(targetFormatted).setType(MenuAction.RUNELITE).onClick(this.addTagToExceptions(targetTag));
        }
    }

    private void addBankTabFilterOptionResults() {
        ArrayList<GeSearch> tagFilters = new ArrayList<GeSearch>();
        List tagNames = Text.fromCSV((String)((String)MoreObjects.firstNonNull((Object)this.configManager.getConfiguration("banktags", "tagtabs"), (Object)"")));
        for (String tag : tagNames) {
            if (this.tagExceptions.contains(tag)) continue;
            String iconItemId = this.configManager.getConfiguration("banktags", "icon_" + tag);
            iconItemId = iconItemId == null ? "952" : iconItemId;
            tagFilters.add(new GeSearch(tag, Short.parseShort(iconItemId)));
        }
        this.setGESearchResults(this.getEmptySearchResults(tagFilters.size()));
        this.setSearchResultsHidden(true);
        this.clientThread.invokeLater(() -> {
            List<GeSearchResultWidget> searchResultWidgets = this.getGeSearchResults();
            this.generateBankTabResults(tagFilters, searchResultWidgets);
            this.setSearchResultsHidden(false);
        });
    }

    private void generateBankTabResults(List<GeSearch> filters, List<GeSearchResultWidget> searchResults) {
        if (searchResults.size() == 0) {
            return;
        }
        int resultIndex = 0;
        int resultSize = searchResults.size();
        for (GeSearch filter : filters) {
            if (resultIndex == resultSize) break;
            String search = filter.getName();
            GeSearchResultWidget searchResult = searchResults.get(resultIndex);
            searchResult.setTitleText(search);
            searchResult.setTooltipText(search);
            searchResult.setItemIcon(filter.getIconItemId());
            searchResult.setOnOpListener(e -> {
                String title = "Bank Tags - " + search;
                String searchVal = "tag:" + search;
                this.searchGE(searchVal);
                this.setTitle(title);
                this.saveSearchState(searchVal);
            });
            ++resultIndex;
        }
    }

    private List<GeSearchResultWidget> getGeSearchResults() {
        ArrayList<GeSearchResultWidget> results = new ArrayList<GeSearchResultWidget>();
        Widget[] geSearchResultWidgets = this.client.getWidget(WidgetInfo.CHATBOX_GE_SEARCH_RESULTS).getDynamicChildren();
        LinkedList<Widget> widgetQueue = new LinkedList<Widget>();
        for (Widget w : geSearchResultWidgets) {
            widgetQueue.add(w);
            if (widgetQueue.size() != 3) continue;
            Widget container = (Widget)widgetQueue.remove();
            Widget title = (Widget)widgetQueue.remove();
            Widget icon = (Widget)widgetQueue.remove();
            short itemId = (short)icon.getItemId();
            results.add(new GeSearchResultWidget(container, title, icon, itemId));
        }
        return results;
    }

    private Consumer<MenuEntry> addTagToExceptions(String tag) {
        return e -> {
            if (this.tagExceptions.contains(tag)) {
                return;
            }
            this.tagExceptions.add(tag);
            this.saveTagExceptions();
        };
    }

    private Consumer<MenuEntry> removeTagFromExceptions(String tag) {
        return e -> {
            if (!this.tagExceptions.contains(tag)) {
                return;
            }
            this.tagExceptions.remove(tag);
            this.saveTagExceptions();
        };
    }

    private void saveTagExceptions() {
        String[] tagExc = new String[this.tagExceptions.size()];
        this.tagExceptions.toArray(tagExc);
        String json = RuneLiteAPI.GSON.toJson((Object)tagExc);
        this.configManager.setConfiguration("GE_FILTERS_CONFIG_DATA", TAG_EXCEPTION_JSON_KEY, json);
    }

    private void loadTagExceptions() {
        String tagExceptionsJson = this.configManager.getConfiguration("GE_FILTERS_CONFIG_DATA", TAG_EXCEPTION_JSON_KEY);
        if (tagExceptionsJson == null || tagExceptionsJson.equals("")) {
            this.tagExceptions = new ArrayList<String>();
        } else {
            String[] tagExc = (String[])RuneLiteAPI.GSON.fromJson(tagExceptionsJson, String[].class);
            this.tagExceptions = new ArrayList<String>(Arrays.asList(tagExc));
        }
    }

    private short[] getEmptySearchResults(int size) {
        short[] ids = new short[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = 0;
        }
        return ids;
    }
}

