/*
 * Decompiled with CFR 0.152.
 */
package com.dylange.organisedcrime.ui;

import com.dylange.organisedcrime.config.OrganisedCrimeConfig;
import com.dylange.organisedcrime.ui.LocationPanel;
import com.dylange.organisedcrime.ui.LocationViewState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganisedCrimePanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(OrganisedCrimePanel.class);
    private final OrganisedCrimeConfig config;
    private final JPanel layoutPanel = new JPanel();
    private final Consumer<Integer> onWorldClicked;

    public OrganisedCrimePanel(OrganisedCrimeConfig config, Consumer<Integer> onWorldClicked) {
        this.config = config;
        this.onWorldClicked = onWorldClicked;
        this.setLayout(new BorderLayout(0, 8));
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.layoutPanel.setLayout(new BoxLayout(this.layoutPanel, 1));
        this.add(this.layoutPanel, "North");
    }

    public void displayEmpty() {
        this.layoutPanel.removeAll();
        PluginErrorPanel errorPanel = new PluginErrorPanel();
        errorPanel.setContent("Organised Crime Tracker", "View the information board to start tracking locations.");
        this.layoutPanel.add((Component)errorPanel);
        this.layoutPanel.revalidate();
    }

    public void display(List<LocationViewState> viewState) {
        this.layoutPanel.removeAll();
        viewState.forEach(locationViewState -> {
            this.layoutPanel.add(new LocationPanel((LocationViewState)locationViewState, this.onWorldClicked));
            this.layoutPanel.revalidate();
        });
    }

    public void refresh() {
        for (Component component : this.layoutPanel.getComponents()) {
            if (!(component instanceof LocationPanel)) continue;
            ((LocationPanel)component).refreshWorldButtons();
        }
    }
}

