/*
 * Decompiled with CFR 0.152.
 */
package com.dylange.organisedcrime.ui;

import com.dylange.organisedcrime.ui.LocationViewState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.function.Consumer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(LocationPanel.class);
    private final LocationViewState viewState;
    private final Consumer<Integer> onWorldClicked;
    private final Color backgroundColour = ColorScheme.DARKER_GRAY_COLOR.darker();
    private final JSeparator separator = new JSeparator(0);
    private final JPanel descriptionContainer = new JPanel();
    private final JPanel worldsContainer = new JPanel();
    private final JTextArea descriptionLabel = new JTextArea();

    public LocationPanel(LocationViewState viewState, Consumer<Integer> onWorldClicked) {
        this.viewState = viewState;
        this.onWorldClicked = onWorldClicked;
        this.setLayout(new BorderLayout(0, 1));
        this.setBackground(this.backgroundColour);
        this.separator.setBackground(ColorScheme.MEDIUM_GRAY_COLOR);
        this.descriptionContainer.setLayout(new GridBagLayout());
        this.descriptionContainer.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.descriptionContainer.setBackground(this.backgroundColour);
        int numRows = viewState.getExpectedTimeToWorld().keySet().size();
        this.worldsContainer.setLayout(new GridLayout(numRows, 1, 0, 2));
        this.worldsContainer.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.worldsContainer.setBackground(this.backgroundColour);
        this.add((Component)this.separator, "North");
        this.add((Component)this.descriptionContainer, "Center");
        this.add((Component)this.worldsContainer, "South");
        this.descriptionLabel.setText(viewState.getDescription());
        this.descriptionLabel.setEditable(false);
        this.descriptionLabel.setWrapStyleWord(true);
        this.descriptionLabel.setLineWrap(true);
        this.descriptionLabel.setFont(FontManager.getRunescapeFont());
        GridBagConstraints descriptionConstraints = new GridBagConstraints();
        descriptionConstraints.fill = 2;
        descriptionConstraints.gridy = 0;
        this.descriptionContainer.add((Component)this.descriptionLabel, descriptionConstraints);
        BufferedImage locationIcon = ImageUtil.loadImageResource(this.getClass(), (String)viewState.getImage());
        JLabel locationImage = new JLabel(new ImageIcon(new ImageIcon(locationIcon).getImage().getScaledInstance(214, 214, 1)));
        GridBagConstraints locationImageConstraints = new GridBagConstraints();
        locationImageConstraints.fill = 2;
        locationImageConstraints.gridy = 1;
        locationImageConstraints.anchor = 10;
        this.descriptionContainer.add((Component)locationImage, locationImageConstraints);
        this.drawWorldsButtons();
    }

    public void refreshWorldButtons() {
        SwingUtilities.invokeLater(this::drawWorldsButtons);
    }

    private void drawWorldsButtons() {
        if (this.worldsContainer == null || this.viewState == null) {
            return;
        }
        this.worldsContainer.removeAll();
        this.viewState.getExpectedTimeToWorld().forEach((expectedTime, world) -> {
            String buttonText = String.format("W%d %s", world, expectedTime.toString());
            JButton worldButton = new JButton(buttonText);
            worldButton.addActionListener(e -> this.onWorldClicked.accept((Integer)world));
            this.worldsContainer.add(worldButton);
        });
        this.worldsContainer.revalidate();
    }
}

