/*
 * Decompiled with CFR 0.152.
 */
package com.dylange.organisedcrime.tools;

import com.dylange.organisedcrime.config.OrganisedCrimeConfig;
import com.dylange.organisedcrime.models.GangExpectedTime;
import com.dylange.organisedcrime.models.GangInfo;
import com.dylange.organisedcrime.models.OrganisedCrimeLocation;
import com.dylange.organisedcrime.ui.LocationViewState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ViewStateMapper {
    public static List<LocationViewState> gangInfoMapToLocationListItems(Map<Integer, GangInfo> gangInfoMap, OrganisedCrimeConfig config) {
        HashMap<OrganisedCrimeLocation, List> locationToInfoMap = new HashMap<OrganisedCrimeLocation, List>();
        gangInfoMap.forEach((world, gangInfo) -> {
            if (!gangInfo.getLocation().isMultiCombat() && config.multiCombatOnly()) {
                return;
            }
            if (gangInfo.getLocation().getArea() == OrganisedCrimeLocation.Area.Arceuus && !config.trackArceuus()) {
                return;
            }
            if (gangInfo.getLocation().getArea() == OrganisedCrimeLocation.Area.Hosidius && !config.trackHosidius()) {
                return;
            }
            if (gangInfo.getLocation().getArea() == OrganisedCrimeLocation.Area.Lovakengj && !config.trackLovakengj()) {
                return;
            }
            if (gangInfo.getLocation().getArea() == OrganisedCrimeLocation.Area.Piscarilius && !config.trackPiscarilius()) {
                return;
            }
            if (gangInfo.getLocation().getArea() == OrganisedCrimeLocation.Area.Shayzien && !config.trackShayzien()) {
                return;
            }
            if (gangInfo.getLocation().getArea() == OrganisedCrimeLocation.Area.Other && !config.trackOther()) {
                return;
            }
            List existingInfo = (List)locationToInfoMap.get(gangInfo.getLocation());
            if (existingInfo == null) {
                locationToInfoMap.put(gangInfo.getLocation(), Collections.singletonList(gangInfo));
            } else {
                ArrayList<GangInfo> updatedList = new ArrayList<GangInfo>(existingInfo);
                updatedList.add((GangInfo)gangInfo);
                locationToInfoMap.put(gangInfo.getLocation(), updatedList);
            }
        });
        ArrayList<LocationViewState> viewStates = new ArrayList<LocationViewState>();
        locationToInfoMap.forEach((organisedCrimeLocation, gangInfoForLocation) -> {
            TreeMap<GangExpectedTime, Integer> worldToExpectedTime = new TreeMap<GangExpectedTime, Integer>();
            gangInfoForLocation.forEach(gangInfo -> worldToExpectedTime.put(gangInfo.getExpectedTime(), gangInfo.getWorld()));
            viewStates.add(new LocationViewState(organisedCrimeLocation.getDescription(), organisedCrimeLocation.getImage(), worldToExpectedTime));
        });
        return viewStates;
    }
}

