/*
 * Decompiled with CFR 0.152.
 */
package com.dylange.organisedcrime.models;

import com.dylange.organisedcrime.models.GangExpectedTime;
import com.dylange.organisedcrime.models.OrganisedCrimeLocation;
import com.dylange.organisedcrime.models.OrganisedCrimeLocations;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GangInfo
implements Comparable<GangInfo> {
    private static final Logger log = LoggerFactory.getLogger(GangInfo.class);
    private static Pattern timeRegex = Pattern.compile("([0-9]+)");
    private static Pattern nowRegex = Pattern.compile(".*(now|imminently).*");
    private String locationMessage;
    private int world;
    private GangExpectedTime expectedTime;
    private OrganisedCrimeLocation correspondingLocation;

    public GangInfo(String locationMessage, String timeMessage, int world) {
        this.locationMessage = locationMessage;
        this.world = world;
        long timeRead = System.currentTimeMillis();
        Matcher timeMatcher = timeRegex.matcher(timeMessage);
        if (timeMatcher.find()) {
            this.expectedTime = new GangExpectedTime(timeRead, Integer.parseInt(timeMatcher.group()));
        } else {
            Matcher nowMatcher = nowRegex.matcher(timeMessage);
            if (nowMatcher.find()) {
                this.expectedTime = new GangExpectedTime(timeRead, 0);
            } else {
                throw new IllegalArgumentException(String.format("Failed to parse time from \"%s\"", timeMessage));
            }
        }
    }

    public String getLocationMessage() {
        return this.locationMessage;
    }

    public int getWorld() {
        return this.world;
    }

    public GangExpectedTime getExpectedTime() {
        return this.expectedTime;
    }

    public OrganisedCrimeLocation getLocation() throws IllegalStateException {
        if (this.correspondingLocation != null) {
            return this.correspondingLocation;
        }
        for (OrganisedCrimeLocation loc : OrganisedCrimeLocations.allLocations) {
            if (!loc.getLocationMessage().equals(this.locationMessage)) continue;
            this.correspondingLocation = loc;
        }
        if (this.correspondingLocation != null) {
            return this.correspondingLocation;
        }
        throw new IllegalStateException("Corresponding location info not found for data read from information board.");
    }

    @Override
    public int compareTo(GangInfo gangInfo) {
        return 0;
    }
}

